/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.net.Server;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.causalclustering.ClusterRule;

public class ConnectionInfoIT {
    private Socket testSocket;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);

    @After
    public void teardown() throws IOException {
        if (this.testSocket != null) {
            this.unbind(this.testSocket);
        }
    }

    @Test
    public void testAddressAlreadyBoundMessage() throws Throwable {
        this.testSocket = this.bindPort("localhost", PortAuthority.allocatePort());
        AssertableLogProvider logProvider = new AssertableLogProvider();
        AssertableLogProvider userLogProvider = new AssertableLogProvider();
        ListenSocketAddress listenSocketAddress = new ListenSocketAddress("localhost", this.testSocket.getLocalPort());
        Server catchupServer = new Server(channel -> {}, (LogProvider)logProvider, (LogProvider)userLogProvider, listenSocketAddress, "server-name");
        try {
            catchupServer.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        logProvider.assertContainsMessageContaining("server-name: address is already bound: ");
        userLogProvider.assertContainsMessageContaining("server-name: address is already bound: ");
    }

    private Socket bindPort(String address, int port) throws IOException {
        Socket socket = new Socket();
        socket.bind(new InetSocketAddress(address, port));
        return socket;
    }

    private void unbind(Socket socket) throws IOException {
        socket.close();
    }
}

