/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.causalclustering.ClusterRule;

@RunWith(value=Parameterized.class)
public class ClusterShutdownIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);
    @Parameterized.Parameter
    public Collection<Integer> shutdownOrder;
    private Cluster cluster;

    @Parameterized.Parameters(name="shutdown order {0}")
    public static Collection<Collection<Integer>> shutdownOrders() {
        return Arrays.asList(Arrays.asList(0, 1, 2), Arrays.asList(1, 2, 0), Arrays.asList(2, 0, 1));
    }

    @Before
    public void startCluster() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @After
    public void shutdownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void shouldShutdownEvenThoughWaitingForLock() throws Exception {
        CoreClusterMember leader = this.cluster.awaitLeader();
        this.shouldShutdownEvenThoughWaitingForLock0(this.cluster, leader.serverId(), this.shutdownOrder);
    }

    private void createANode(AtomicReference<Node> node) throws Exception {
        this.cluster.coreTx((coreGraphDatabase, transaction) -> {
            node.set(coreGraphDatabase.createNode());
            transaction.success();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldShutdownEvenThoughWaitingForLock0(Cluster cluster, int victimId, Collection<Integer> shutdownOrder) throws Exception {
        int LONG_TIME = 60000;
        int NUMBER_OF_LOCK_ACQUIRERS = 2;
        ExecutorService txExecutor = Executors.newCachedThreadPool();
        ExecutorService shutdownExecutor = Executors.newFixedThreadPool(1);
        CountDownLatch acquiredLocksCountdown = new CountDownLatch(2);
        CountDownLatch locksHolder = new CountDownLatch(1);
        AtomicReference<Node> node = new AtomicReference<Node>();
        CompletableFuture preShutdown = new CompletableFuture();
        CompletionStage afterShutdown = preShutdown;
        for (Integer id : shutdownOrder) {
            afterShutdown = ((CompletableFuture)afterShutdown).thenRunAsync(() -> cluster.getCoreMemberById(id).shutdown(), shutdownExecutor);
        }
        this.createANode(node);
        try {
            CoreGraphDatabase leader = cluster.getCoreMemberById(victimId).database();
            for (int i = 0; i < 2; ++i) {
                txExecutor.execute(() -> ClusterShutdownIT.lambda$shouldShutdownEvenThoughWaitingForLock0$2((GraphDatabaseService)leader, acquiredLocksCountdown, node, locksHolder));
            }
            if (!acquiredLocksCountdown.await(60000L, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("Failed to acquire locks");
            }
            preShutdown.complete(null);
            ((CompletableFuture)afterShutdown).get(60000L, TimeUnit.MILLISECONDS);
        }
        finally {
            ((CompletableFuture)afterShutdown).cancel(true);
            locksHolder.countDown();
            txExecutor.shutdownNow();
            shutdownExecutor.shutdownNow();
        }
    }

    private static /* synthetic */ void lambda$shouldShutdownEvenThoughWaitingForLock0$2(GraphDatabaseService leader, CountDownLatch acquiredLocksCountdown, AtomicReference node, CountDownLatch locksHolder) {
        try (Transaction tx = leader.beginTx();){
            acquiredLocksCountdown.countDown();
            tx.acquireWriteLock((PropertyContainer)node.get());
            locksHolder.await();
            tx.success();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

