/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.causalclustering.ClusterRule;

public class ClusterIndexProcedureIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(3).withTimeout(1000L, TimeUnit.SECONDS);
    private Cluster cluster;

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void createIndexProcedureMustPropagate() throws Exception {
        this.cluster.coreTx((db, tx) -> {
            Node person = db.createNode(new Label[]{Label.label((String)"Person")});
            person.setProperty("name", (Object)"Bo Burnham");
            tx.success();
        });
        CoreClusterMember leader = this.cluster.coreTx((db, tx) -> {
            db.execute("CALL db.createIndex( \":Person(name)\", \"lucene+native-1.0\")").close();
            tx.success();
        });
        this.awaitIndexOnline(leader);
        Cluster.dataMatchesEventually(leader, this.cluster.coreMembers());
        Cluster.dataMatchesEventually(leader, this.cluster.readReplicas());
        for (CoreClusterMember core : this.cluster.coreMembers()) {
            this.verifyIndexes((GraphDatabaseFacade)core.database());
        }
        for (ReadReplica readReplica : this.cluster.readReplicas()) {
            this.verifyIndexes((GraphDatabaseFacade)readReplica.database());
        }
    }

    @Test
    public void createUniquePropertyConstraintMustPropagate() throws Exception {
        this.cluster.coreTx((db, tx) -> {
            Node person = db.createNode(new Label[]{Label.label((String)"Person")});
            person.setProperty("name", (Object)"Bo Burnham");
            tx.success();
        });
        CoreClusterMember leader = this.cluster.coreTx((db, tx) -> {
            db.execute("CALL db.createUniquePropertyConstraint( \":Person(name)\", \"lucene+native-1.0\")").close();
            tx.success();
        });
        Cluster.dataMatchesEventually(leader, this.cluster.coreMembers());
        Cluster.dataMatchesEventually(leader, this.cluster.readReplicas());
        for (CoreClusterMember core : this.cluster.coreMembers()) {
            this.verifyIndexes((GraphDatabaseFacade)core.database());
            this.verifyConstraints((GraphDatabaseFacade)core.database(), ConstraintType.UNIQUENESS);
        }
        for (ReadReplica readReplica : this.cluster.readReplicas()) {
            this.verifyIndexes((GraphDatabaseFacade)readReplica.database());
            this.verifyConstraints((GraphDatabaseFacade)readReplica.database(), ConstraintType.UNIQUENESS);
        }
    }

    @Test
    public void createNodeKeyConstraintMustPropagate() throws Exception {
        this.cluster.coreTx((db, tx) -> {
            Node person = db.createNode(new Label[]{Label.label((String)"Person")});
            person.setProperty("name", (Object)"Bo Burnham");
            tx.success();
        });
        CoreClusterMember leader = this.cluster.coreTx((db, tx) -> {
            db.execute("CALL db.createNodeKey( \":Person(name)\", \"lucene+native-1.0\")").close();
            tx.success();
        });
        Cluster.dataMatchesEventually(leader, this.cluster.coreMembers());
        Cluster.dataMatchesEventually(leader, this.cluster.readReplicas());
        for (CoreClusterMember core : this.cluster.coreMembers()) {
            this.verifyIndexes((GraphDatabaseFacade)core.database());
            this.verifyConstraints((GraphDatabaseFacade)core.database(), ConstraintType.NODE_KEY);
        }
        for (ReadReplica readReplica : this.cluster.readReplicas()) {
            this.verifyIndexes((GraphDatabaseFacade)readReplica.database());
            this.verifyConstraints((GraphDatabaseFacade)readReplica.database(), ConstraintType.NODE_KEY);
        }
    }

    private void awaitIndexOnline(CoreClusterMember member) {
        CoreGraphDatabase db = member.database();
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
    }

    private void verifyIndexes(GraphDatabaseFacade database) {
        try (Transaction tx = database.beginTx();){
            Iterator indexes = database.schema().getIndexes().iterator();
            Assert.assertTrue((String)"has one index", (boolean)indexes.hasNext());
            IndexDefinition indexDefinition = (IndexDefinition)indexes.next();
            Assert.assertFalse((String)"not more than one index", (boolean)indexes.hasNext());
            Label label = indexDefinition.getLabel();
            String property = (String)indexDefinition.getPropertyKeys().iterator().next();
            Assert.assertEquals((String)"correct label", (Object)"Person", (Object)label.name());
            Assert.assertEquals((String)"correct property", (Object)"name", (Object)property);
            this.assertCorrectProvider((GraphDatabaseAPI)database, label, property);
            tx.success();
        }
    }

    private void verifyConstraints(GraphDatabaseFacade database, ConstraintType expectedConstraintType) {
        try (Transaction tx = database.beginTx();){
            Iterator constraints = database.schema().getConstraints().iterator();
            Assert.assertTrue((String)"has one index", (boolean)constraints.hasNext());
            ConstraintDefinition constraint = (ConstraintDefinition)constraints.next();
            Assert.assertFalse((String)"not more than one index", (boolean)constraints.hasNext());
            Label label = constraint.getLabel();
            String property = (String)constraint.getPropertyKeys().iterator().next();
            ConstraintType constraintType = constraint.getConstraintType();
            Assert.assertEquals((String)"correct label", (Object)"Person", (Object)label.name());
            Assert.assertEquals((String)"correct property", (Object)"name", (Object)property);
            Assert.assertEquals((String)"correct constraint type", (Object)expectedConstraintType, (Object)constraintType);
            tx.success();
        }
    }

    private void assertCorrectProvider(GraphDatabaseAPI db, Label label, String property) {
        KernelTransaction kernelTransaction = ((ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(false);
        TokenRead tokenRead = kernelTransaction.tokenRead();
        int labelId = tokenRead.nodeLabel(label.name());
        int propId = tokenRead.propertyKey(property);
        SchemaRead schemaRead = kernelTransaction.schemaRead();
        IndexReference index = schemaRead.index(labelId, new int[]{propId});
        Assert.assertEquals((String)"correct provider key", (Object)"lucene+native", (Object)index.providerKey());
        Assert.assertEquals((String)"correct provider version", (Object)"1.0", (Object)index.providerVersion());
    }
}

