/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.multi_cluster.procedure;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.GetRoutersForAllDatabasesProcedure;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.GetRoutersForDatabaseProcedure;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.configuration.Config;

public class MultiClusterRoutingProcedureTest {
    @Test
    public void subClusterRoutingProcedureShouldHaveCorrectSignature() {
        GetRoutersForDatabaseProcedure proc = new GetRoutersForDatabaseProcedure(null, Config.defaults());
        ProcedureSignature procSig = proc.signature();
        List<FieldSignature> input = Collections.singletonList(FieldSignature.inputField((String)"database", (Neo4jTypes.AnyType)Neo4jTypes.NTString));
        List<FieldSignature> output = Arrays.asList(FieldSignature.outputField((String)"ttl", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger), FieldSignature.outputField((String)"routers", (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTMap)));
        Assert.assertEquals((String)"The input signature of the GetRoutersForDatabaseProcedure should not change.", (Object)procSig.inputSignature(), input);
        Assert.assertEquals((String)"The output signature of the GetRoutersForDatabaseProcedure should not change.", (Object)procSig.outputSignature(), output);
    }

    @Test
    public void superClusterRoutingProcedureShouldHaveCorrectSignature() {
        GetRoutersForAllDatabasesProcedure proc = new GetRoutersForAllDatabasesProcedure(null, Config.defaults());
        ProcedureSignature procSig = proc.signature();
        List<FieldSignature> output = Arrays.asList(FieldSignature.outputField((String)"ttl", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger), FieldSignature.outputField((String)"routers", (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTMap)));
        Assert.assertEquals((String)"The output signature of the GetRoutersForAllDatabasesProcedure should not change.", (Object)procSig.outputSignature(), output);
    }
}

