/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing.procedure;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.routing.Endpoint;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingProcessor;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingResult;
import org.neo4j.causalclustering.routing.load_balancing.procedure.ResultFormatV1;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class ResultFormatV1Test {
    @Test
    public void shouldSerializeToAndFromRecordFormat() {
        List<Endpoint> writers = Arrays.asList(Endpoint.write((AdvertisedSocketAddress)new AdvertisedSocketAddress("write", 1)), Endpoint.write((AdvertisedSocketAddress)new AdvertisedSocketAddress("write", 2)), Endpoint.write((AdvertisedSocketAddress)new AdvertisedSocketAddress("write", 3)));
        List<Endpoint> readers = Arrays.asList(Endpoint.read((AdvertisedSocketAddress)new AdvertisedSocketAddress("read", 4)), Endpoint.read((AdvertisedSocketAddress)new AdvertisedSocketAddress("read", 5)), Endpoint.read((AdvertisedSocketAddress)new AdvertisedSocketAddress("read", 6)), Endpoint.read((AdvertisedSocketAddress)new AdvertisedSocketAddress("read", 7)));
        List<Endpoint> routers = Collections.singletonList(Endpoint.route((AdvertisedSocketAddress)new AdvertisedSocketAddress("route", 8)));
        long ttlSeconds = 5L;
        LoadBalancingResult original = new LoadBalancingResult(routers, writers, readers, ttlSeconds * 1000L);
        Object[] record = ResultFormatV1.build((LoadBalancingProcessor.Result)original);
        LoadBalancingResult parsed = ResultFormatV1.parse((Object[])record);
        Assert.assertEquals((Object)original, (Object)parsed);
    }

    @Test
    public void shouldSerializeToAndFromRecordFormatWithNoEntries() {
        List writers = Collections.emptyList();
        List readers = Collections.emptyList();
        List routers = Collections.emptyList();
        long ttlSeconds = 0L;
        LoadBalancingResult original = new LoadBalancingResult(routers, writers, readers, ttlSeconds * 1000L);
        Object[] record = ResultFormatV1.build((LoadBalancingProcessor.Result)original);
        LoadBalancingResult parsed = ResultFormatV1.parse((Object[])record);
        Assert.assertEquals((Object)original, (Object)parsed);
    }
}

