/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing.procedure;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingPlugin;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingProcessor;
import org.neo4j.causalclustering.routing.load_balancing.procedure.GetServersProcedureForMultiDC;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;

public class GetServersProcedureV2Test {
    @Test
    public void shouldHaveCorrectSignature() {
        GetServersProcedureForMultiDC proc = new GetServersProcedureForMultiDC(null);
        ProcedureSignature signature = proc.signature();
        MatcherAssert.assertThat((Object)signature.inputSignature(), (Matcher)Matchers.containsInAnyOrder((Object[])new FieldSignature[]{FieldSignature.inputField((String)"context", (Neo4jTypes.AnyType)Neo4jTypes.NTMap)}));
        MatcherAssert.assertThat((Object)signature.outputSignature(), (Matcher)Matchers.containsInAnyOrder((Object[])new FieldSignature[]{FieldSignature.outputField((String)"ttl", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger), FieldSignature.outputField((String)"servers", (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTMap))}));
    }

    @Test
    public void shouldPassClientContextToPlugin() throws Exception {
        LoadBalancingPlugin plugin = (LoadBalancingPlugin)Mockito.mock(LoadBalancingPlugin.class);
        LoadBalancingProcessor.Result result = (LoadBalancingProcessor.Result)Mockito.mock(LoadBalancingProcessor.Result.class);
        Mockito.when((Object)plugin.run(ArgumentMatchers.anyMap())).thenReturn((Object)result);
        GetServersProcedureForMultiDC getServers = new GetServersProcedureForMultiDC((LoadBalancingProcessor)plugin);
        Map clientContext = MapUtil.stringMap((String[])new String[]{"key", "value", "key2", "value2"});
        getServers.apply(null, new Object[]{clientContext}, null);
        ((LoadBalancingPlugin)Mockito.verify((Object)plugin)).run(clientContext);
    }
}

