/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.readreplica.ReadReplicaLockManager;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;

public class ReadReplicaLockManagerTest {
    private ReadReplicaLockManager lockManager = new ReadReplicaLockManager();
    private Locks.Client lockClient = this.lockManager.newClient();

    @Test
    public void shouldThrowOnAcquireExclusiveLock() {
        try {
            this.lockClient.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        }
        catch (Exception e) {
            Assert.assertEquals((Object)Status.General.ForbiddenOnReadOnlyDatabase, (Object)Status.statusCodeOf((Throwable)e));
        }
    }

    @Test
    public void shouldThrowOnTryAcquireExclusiveLock() {
        try {
            this.lockClient.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)Status.General.ForbiddenOnReadOnlyDatabase, (Object)Status.statusCodeOf((Throwable)e));
        }
    }

    @Test
    public void shouldAcceptSharedLocks() {
        this.lockClient.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.lockClient.trySharedLock((ResourceType)ResourceTypes.NODE, 1L);
    }
}

