/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.ClientMessageEncoder;
import org.neo4j.causalclustering.protocol.handshake.InitialMagicMessage;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.ServerMessage;
import org.neo4j.causalclustering.protocol.handshake.ServerMessageDecoder;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverRequest;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;

@RunWith(value=Parameterized.class)
public class ServerMessageEncodingTest {
    private final ServerMessage message;
    private final ClientMessageEncoder encoder = new ClientMessageEncoder();
    private final ServerMessageDecoder decoder = new ServerMessageDecoder();

    private List<Object> encodeDecode(ServerMessage message) {
        ByteBuf byteBuf = Unpooled.directBuffer();
        ArrayList<Object> output = new ArrayList<Object>();
        this.encoder.encode(null, message, byteBuf);
        this.decoder.decode(null, byteBuf, output);
        return output;
    }

    @Parameterized.Parameters(name="ResponseMessage-{0}")
    public static Collection<ServerMessage> data() {
        return Arrays.asList(new ApplicationProtocolRequest("protocol", Iterators.asSet((Object[])new Integer[]{3, 7, 13})), new InitialMagicMessage("Magic string"), new ModifierProtocolRequest("modifierProtocol", Iterators.asSet((Object[])new String[]{"Foo", "Bar", "Baz"})), new SwitchOverRequest("protocol", 38, Collections.emptyList()), new SwitchOverRequest("protocol", 38, Arrays.asList(Pair.of((Object)"mod1", (Object)"Foo"), Pair.of((Object)"mod2", (Object)"Quux"))));
    }

    public ServerMessageEncodingTest(ServerMessage message) {
        this.message = message;
    }

    @Test
    public void shouldCompleteEncodingRoundTrip() {
        List<Object> output = this.encodeDecode(this.message);
        Assert.assertThat(output, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)output.get(0), (Matcher)Matchers.equalTo((Object)this.message));
    }
}

