/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.junit.Test;
import org.neo4j.causalclustering.messaging.Channel;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ClientHandshakeException;
import org.neo4j.causalclustering.protocol.handshake.HandshakeClient;
import org.neo4j.causalclustering.protocol.handshake.HandshakeServer;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ProtocolHandshakeHappyTest;
import org.neo4j.causalclustering.protocol.handshake.ServerHandshakeException;
import org.neo4j.causalclustering.protocol.handshake.TestProtocols;

public class ProtocolHandshakeSadTest {
    private ApplicationSupportedProtocols supportedRaftApplicationProtocol = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, Collections.emptyList());
    private ApplicationSupportedProtocols supportedCatchupApplicationProtocol = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.CATCHUP, Collections.emptyList());
    private Collection<ModifierSupportedProtocols> noModifiers = Collections.emptyList();
    private ApplicationProtocolRepository raftApplicationProtocolRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])TestProtocols.TestApplicationProtocols.values(), this.supportedRaftApplicationProtocol);
    private ApplicationProtocolRepository catchupApplicationProtocolRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])TestProtocols.TestApplicationProtocols.values(), this.supportedCatchupApplicationProtocol);
    private ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), this.noModifiers);
    private HandshakeClient handshakeClient = new HandshakeClient();

    @Test(expected=ClientHandshakeException.class)
    public void shouldFailHandshakeForUnknownProtocolOnClient() throws Throwable {
        HandshakeServer handshakeServer = new HandshakeServer(this.raftApplicationProtocolRepository, this.modifierProtocolRepository, (Channel)new ProtocolHandshakeHappyTest.FakeServerChannel(this.handshakeClient));
        ProtocolHandshakeHappyTest.FakeClientChannel clientChannel = new ProtocolHandshakeHappyTest.FakeClientChannel(handshakeServer);
        CompletableFuture clientHandshakeFuture = this.handshakeClient.initiate((Channel)clientChannel, this.catchupApplicationProtocolRepository, this.modifierProtocolRepository);
        try {
            clientHandshakeFuture.getNow(null);
        }
        catch (CompletionException ex) {
            throw ex.getCause();
        }
    }

    @Test(expected=ServerHandshakeException.class)
    public void shouldFailHandshakeForUnknownProtocolOnServer() throws Throwable {
        HandshakeServer handshakeServer = new HandshakeServer(this.raftApplicationProtocolRepository, this.modifierProtocolRepository, (Channel)new ProtocolHandshakeHappyTest.FakeServerChannel(this.handshakeClient));
        ProtocolHandshakeHappyTest.FakeClientChannel clientChannel = new ProtocolHandshakeHappyTest.FakeClientChannel(handshakeServer);
        this.handshakeClient.initiate((Channel)clientChannel, this.catchupApplicationProtocolRepository, this.modifierProtocolRepository);
        CompletableFuture serverHandshakeFuture = handshakeServer.protocolStackFuture();
        try {
            serverHandshakeFuture.getNow(null);
        }
        catch (CompletionException ex) {
            throw ex.getCause();
        }
    }
}

