/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.messaging.Channel;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ClientMessage;
import org.neo4j.causalclustering.protocol.handshake.ClientMessageHandler;
import org.neo4j.causalclustering.protocol.handshake.HandshakeClient;
import org.neo4j.causalclustering.protocol.handshake.HandshakeServer;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.causalclustering.protocol.handshake.ServerMessage;
import org.neo4j.causalclustering.protocol.handshake.ServerMessageHandler;
import org.neo4j.causalclustering.protocol.handshake.TestProtocols;
import org.neo4j.helpers.collection.Iterators;

@RunWith(value=Parameterized.class)
public class ProtocolHandshakeHappyTest {
    @Parameterized.Parameter
    public Parameters parameters;

    @Parameterized.Parameters
    public static Collection<Parameters> data() {
        ApplicationSupportedProtocols allRaft = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, TestProtocols.TestApplicationProtocols.listVersionsOf(Protocol.ApplicationProtocolCategory.RAFT));
        ApplicationSupportedProtocols raft1 = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, Collections.singletonList(TestProtocols.TestApplicationProtocols.RAFT_1.implementation()));
        ApplicationSupportedProtocols allRaftByDefault = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, Collections.emptyList());
        List<ModifierSupportedProtocols> allModifiers = Arrays.asList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, TestProtocols.TestModifierProtocols.listVersionsOf(Protocol.ModifierProtocolCategory.COMPRESSION)), new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION, TestProtocols.TestModifierProtocols.listVersionsOf(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION)));
        List<ModifierSupportedProtocols> allCompressionModifiers = Collections.singletonList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, TestProtocols.TestModifierProtocols.listVersionsOf(Protocol.ModifierProtocolCategory.COMPRESSION)));
        List<ModifierSupportedProtocols> allObfuscationModifiers = Collections.singletonList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION, TestProtocols.TestModifierProtocols.listVersionsOf(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION)));
        List<ModifierSupportedProtocols> allCompressionModifiersByDefault = Collections.singletonList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, Collections.emptyList()));
        List<ModifierSupportedProtocols> onlyLzoCompressionModifiers = Collections.singletonList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, Collections.singletonList(TestProtocols.TestModifierProtocols.LZO.implementation())));
        List<ModifierSupportedProtocols> onlySnappyCompressionModifiers = Collections.singletonList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, Collections.singletonList(TestProtocols.TestModifierProtocols.SNAPPY.implementation())));
        List<ModifierSupportedProtocols> noModifiers = Collections.emptyList();
        ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), allModifiers);
        Object[] lzoFirstVersions = new String[]{TestProtocols.TestModifierProtocols.LZO.implementation(), TestProtocols.TestModifierProtocols.LZ4.implementation(), TestProtocols.TestModifierProtocols.SNAPPY.implementation()};
        List<ModifierSupportedProtocols> lzoFirstCompressionModifiers = Collections.singletonList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, Arrays.asList(lzoFirstVersions)));
        Protocol.ModifierProtocol preferredLzoFirstCompressionModifier = (Protocol.ModifierProtocol)modifierProtocolRepository.select(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), Iterators.asSet((Object[])lzoFirstVersions)).get();
        Object[] snappyFirstVersions = new String[]{TestProtocols.TestModifierProtocols.SNAPPY.implementation(), TestProtocols.TestModifierProtocols.LZ4.implementation(), TestProtocols.TestModifierProtocols.LZO.implementation()};
        List<ModifierSupportedProtocols> snappyFirstCompressionModifiers = Collections.singletonList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, Arrays.asList(snappyFirstVersions)));
        Protocol.ModifierProtocol preferredSnappyFirstCompressionModifier = (Protocol.ModifierProtocol)modifierProtocolRepository.select(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), Iterators.asSet((Object[])snappyFirstVersions)).get();
        return Arrays.asList(new Parameters(allRaft, allRaft, allModifiers, allModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.COMPRESSION), TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION)}), new Parameters(allRaft, allRaftByDefault, allModifiers, allModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.COMPRESSION), TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION)}), new Parameters(allRaftByDefault, allRaft, allModifiers, allModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.COMPRESSION), TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION)}), new Parameters(allRaft, raft1, allModifiers, allModifiers, TestProtocols.TestApplicationProtocols.RAFT_1, new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.COMPRESSION), TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION)}), new Parameters(raft1, allRaft, allModifiers, allModifiers, TestProtocols.TestApplicationProtocols.RAFT_1, new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.COMPRESSION), TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION)}), new Parameters(allRaft, allRaft, allModifiers, allCompressionModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.COMPRESSION)}), new Parameters(allRaft, allRaft, allCompressionModifiers, allModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.COMPRESSION)}), new Parameters(allRaft, allRaft, allModifiers, allCompressionModifiersByDefault, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.COMPRESSION)}), new Parameters(allRaft, allRaft, allCompressionModifiersByDefault, allModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.COMPRESSION)}), new Parameters(allRaft, allRaft, allModifiers, allObfuscationModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION)}), new Parameters(allRaft, allRaft, allObfuscationModifiers, allModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION)}), new Parameters(allRaft, allRaft, allModifiers, lzoFirstCompressionModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.LZO}), new Parameters(allRaft, allRaft, lzoFirstCompressionModifiers, allCompressionModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{preferredLzoFirstCompressionModifier}), new Parameters(allRaft, allRaft, allModifiers, snappyFirstCompressionModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.SNAPPY}), new Parameters(allRaft, allRaft, snappyFirstCompressionModifiers, allCompressionModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{preferredSnappyFirstCompressionModifier}), new Parameters(allRaft, allRaft, allModifiers, onlyLzoCompressionModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.LZO}), new Parameters(allRaft, allRaft, onlyLzoCompressionModifiers, allModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.LZO}), new Parameters(allRaft, allRaft, onlySnappyCompressionModifiers, onlyLzoCompressionModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[0]), new Parameters(allRaft, allRaft, onlyLzoCompressionModifiers, onlySnappyCompressionModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[0]), new Parameters(allRaft, allRaft, allModifiers, noModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[0]), new Parameters(allRaft, allRaft, noModifiers, allModifiers, TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT), new Protocol.ModifierProtocol[0]));
    }

    @Test
    public void shouldHandshakeApplicationProtocolOnClient() {
        Fixture fixture = new Fixture(this.parameters);
        CompletableFuture clientHandshakeFuture = fixture.initiate();
        Assert.assertFalse((boolean)fixture.clientChannel.isClosed());
        ProtocolStack clientProtocolStack = clientHandshakeFuture.getNow(null);
        Assert.assertThat((Object)clientProtocolStack.applicationProtocol(), (Matcher)Matchers.equalTo((Object)this.parameters.expectedApplicationProtocol));
    }

    @Test
    public void shouldHandshakeModifierProtocolsOnClient() {
        Fixture fixture = new Fixture(this.parameters);
        CompletableFuture clientHandshakeFuture = fixture.initiate();
        Assert.assertFalse((boolean)fixture.clientChannel.isClosed());
        ProtocolStack clientProtocolStack = clientHandshakeFuture.getNow(null);
        if (this.parameters.expectedModifierProtocols.length == 0) {
            Assert.assertThat((Object)clientProtocolStack.modifierProtocols(), (Matcher)Matchers.empty());
        } else {
            Assert.assertThat((Object)clientProtocolStack.modifierProtocols(), (Matcher)Matchers.contains((Object[])this.parameters.expectedModifierProtocols));
        }
    }

    @Test
    public void shouldHandshakeApplicationProtocolOnServer() {
        Fixture fixture = new Fixture(this.parameters);
        fixture.initiate();
        fixture.handshakeServer.protocolStackFuture();
        CompletableFuture serverHandshakeFuture = fixture.handshakeServer.protocolStackFuture();
        Assert.assertFalse((boolean)fixture.clientChannel.isClosed());
        ProtocolStack serverProtocolStack = serverHandshakeFuture.getNow(null);
        Assert.assertThat((Object)serverProtocolStack.applicationProtocol(), (Matcher)Matchers.equalTo((Object)this.parameters.expectedApplicationProtocol));
    }

    @Test
    public void shouldHandshakeModifierProtocolsOnServer() {
        Fixture fixture = new Fixture(this.parameters);
        fixture.initiate();
        fixture.handshakeServer.protocolStackFuture();
        CompletableFuture serverHandshakeFuture = fixture.handshakeServer.protocolStackFuture();
        Assert.assertFalse((boolean)fixture.clientChannel.isClosed());
        ProtocolStack serverProtocolStack = serverHandshakeFuture.getNow(null);
        if (this.parameters.expectedModifierProtocols.length == 0) {
            Assert.assertThat((Object)serverProtocolStack.modifierProtocols(), (Matcher)Matchers.empty());
        } else {
            Assert.assertThat((Object)serverProtocolStack.modifierProtocols(), (Matcher)Matchers.contains((Object[])this.parameters.expectedModifierProtocols));
        }
    }

    static class FakeClientChannel
    extends FakeChannelWrapper {
        private final HandshakeServer handshakeServer;

        FakeClientChannel(HandshakeServer handshakeServer) {
            this.handshakeServer = handshakeServer;
        }

        @Override
        public CompletableFuture<Void> write(Object msg) {
            ((ServerMessage)msg).dispatch((ServerMessageHandler)this.handshakeServer);
            return CompletableFuture.completedFuture(null);
        }
    }

    static class FakeServerChannel
    extends FakeChannelWrapper {
        private final HandshakeClient handshakeClient;

        FakeServerChannel(HandshakeClient handshakeClient) {
            this.handshakeClient = handshakeClient;
        }

        @Override
        public CompletableFuture<Void> write(Object msg) {
            ((ClientMessage)msg).dispatch((ClientMessageHandler)this.handshakeClient);
            return CompletableFuture.completedFuture(null);
        }
    }

    static abstract class FakeChannelWrapper
    implements Channel {
        private boolean closed;

        FakeChannelWrapper() {
        }

        public boolean isDisposed() {
            return this.closed;
        }

        public void dispose() {
            this.closed = true;
        }

        public boolean isOpen() {
            return true;
        }

        public abstract CompletableFuture<Void> write(Object var1);

        public CompletableFuture<Void> writeAndFlush(Object msg) {
            return this.write(msg);
        }

        boolean isClosed() {
            return this.closed;
        }
    }

    static class Parameters {
        final ApplicationSupportedProtocols clientApplicationProtocol;
        final ApplicationSupportedProtocols serverApplicationProtocol;
        final Collection<ModifierSupportedProtocols> clientModifierProtocols;
        final Collection<ModifierSupportedProtocols> serverModifierProtocols;
        final Protocol.ApplicationProtocol expectedApplicationProtocol;
        final Protocol.ModifierProtocol[] expectedModifierProtocols;

        Parameters(ApplicationSupportedProtocols clientApplicationProtocol, ApplicationSupportedProtocols serverApplicationProtocol, Collection<ModifierSupportedProtocols> clientModifierProtocols, Collection<ModifierSupportedProtocols> serverModifierProtocols, Protocol.ApplicationProtocol expectedApplicationProtocol, Protocol.ModifierProtocol[] expectedModifierProtocols) {
            this.clientModifierProtocols = clientModifierProtocols;
            this.clientApplicationProtocol = clientApplicationProtocol;
            this.serverApplicationProtocol = serverApplicationProtocol;
            this.serverModifierProtocols = serverModifierProtocols;
            this.expectedApplicationProtocol = expectedApplicationProtocol;
            this.expectedModifierProtocols = expectedModifierProtocols;
        }
    }

    static class Fixture {
        final HandshakeClient handshakeClient;
        final HandshakeServer handshakeServer;
        final FakeChannelWrapper clientChannel;
        final ApplicationProtocolRepository clientApplicationProtocolRepository;
        final ModifierProtocolRepository clientModifierProtocolRepository;
        final Parameters parameters;

        Fixture(Parameters parameters) {
            ApplicationProtocolRepository serverApplicationProtocolRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])TestProtocols.TestApplicationProtocols.values(), parameters.serverApplicationProtocol);
            ModifierProtocolRepository serverModifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), parameters.serverModifierProtocols);
            this.clientApplicationProtocolRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])TestProtocols.TestApplicationProtocols.values(), parameters.clientApplicationProtocol);
            this.clientModifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), parameters.clientModifierProtocols);
            this.handshakeClient = new HandshakeClient();
            this.handshakeServer = new HandshakeServer(serverApplicationProtocolRepository, serverModifierProtocolRepository, (Channel)new FakeServerChannel(this.handshakeClient));
            this.clientChannel = new FakeClientChannel(this.handshakeServer);
            this.parameters = parameters;
        }

        private CompletableFuture<ProtocolStack> initiate() {
            return this.handshakeClient.initiate((Channel)this.clientChannel, this.clientApplicationProtocolRepository, this.clientModifierProtocolRepository);
        }
    }
}

