/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.causalclustering.messaging.Channel;
import org.neo4j.causalclustering.messaging.SimpleNettyChannel;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ClientHandshakeException;
import org.neo4j.causalclustering.protocol.handshake.ClientMessageDecoder;
import org.neo4j.causalclustering.protocol.handshake.ClientMessageEncoder;
import org.neo4j.causalclustering.protocol.handshake.HandshakeClient;
import org.neo4j.causalclustering.protocol.handshake.HandshakeServer;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.NettyHandshakeClient;
import org.neo4j.causalclustering.protocol.handshake.NettyHandshakeServer;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.causalclustering.protocol.handshake.ServerHandshakeException;
import org.neo4j.causalclustering.protocol.handshake.ServerMessageDecoder;
import org.neo4j.causalclustering.protocol.handshake.ServerMessageEncoder;
import org.neo4j.causalclustering.protocol.handshake.TestProtocols;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class NettyProtocolHandshakeIT {
    private ApplicationSupportedProtocols supportedRaftApplicationProtocol = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, Collections.emptyList());
    private ApplicationSupportedProtocols supportedCatchupApplicationProtocol = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.CATCHUP, Collections.emptyList());
    private Collection<ModifierSupportedProtocols> supportedCompressionModifierProtocols = Arrays.asList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, TestProtocols.TestModifierProtocols.listVersionsOf(Protocol.ModifierProtocolCategory.COMPRESSION)));
    private Collection<ModifierSupportedProtocols> noSupportedModifierProtocols = Collections.emptyList();
    private ApplicationProtocolRepository raftApplicationProtocolRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])TestProtocols.TestApplicationProtocols.values(), this.supportedRaftApplicationProtocol);
    private ApplicationProtocolRepository catchupApplicationProtocolRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])TestProtocols.TestApplicationProtocols.values(), this.supportedCatchupApplicationProtocol);
    private ModifierProtocolRepository compressionModifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), this.supportedCompressionModifierProtocols);
    private ModifierProtocolRepository unsupportingModifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), this.noSupportedModifierProtocols);
    private Server server;
    private HandshakeClient handshakeClient;
    private Client client;

    @Before
    public void setUp() {
        this.server = new Server();
        this.server.start(this.raftApplicationProtocolRepository, this.compressionModifierProtocolRepository);
        this.handshakeClient = new HandshakeClient();
        this.client = new Client(this.handshakeClient);
        this.client.connect(this.server.port());
    }

    @After
    public void tearDown() {
        this.client.disconnect();
        this.server.stop();
    }

    @Test
    public void shouldSuccessfullyHandshakeKnownProtocolOnClientWithCompression() throws Exception {
        CompletableFuture clientHandshakeFuture = this.handshakeClient.initiate((Channel)new SimpleNettyChannel(this.client.channel, (Log)NullLog.getInstance()), this.raftApplicationProtocolRepository, this.compressionModifierProtocolRepository);
        ProtocolStack clientProtocolStack = (ProtocolStack)clientHandshakeFuture.get(1L, TimeUnit.MINUTES);
        Assert.assertThat((Object)clientProtocolStack.applicationProtocol(), (Matcher)Matchers.equalTo((Object)TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT)));
        Assert.assertThat((Object)clientProtocolStack.modifierProtocols(), (Matcher)Matchers.contains((Object[])new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.COMPRESSION)}));
    }

    @Test
    public void shouldSuccessfullyHandshakeKnownProtocolOnServerWithCompression() throws Exception {
        CompletableFuture clientFuture = this.handshakeClient.initiate((Channel)new SimpleNettyChannel(this.client.channel, (Log)NullLog.getInstance()), this.raftApplicationProtocolRepository, this.compressionModifierProtocolRepository);
        CompletableFuture<ProtocolStack> serverHandshakeFuture = this.getServerHandshakeFuture(clientFuture);
        ProtocolStack serverProtocolStack = serverHandshakeFuture.get(1L, TimeUnit.MINUTES);
        Assert.assertThat((Object)serverProtocolStack.applicationProtocol(), (Matcher)Matchers.equalTo((Object)TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT)));
        Assert.assertThat((Object)serverProtocolStack.modifierProtocols(), (Matcher)Matchers.contains((Object[])new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.COMPRESSION)}));
    }

    @Test
    public void shouldSuccessfullyHandshakeKnownProtocolOnClientNoModifiers() throws Exception {
        CompletableFuture clientHandshakeFuture = this.handshakeClient.initiate((Channel)new SimpleNettyChannel(this.client.channel, (Log)NullLog.getInstance()), this.raftApplicationProtocolRepository, this.unsupportingModifierProtocolRepository);
        ProtocolStack clientProtocolStack = (ProtocolStack)clientHandshakeFuture.get(1L, TimeUnit.MINUTES);
        Assert.assertThat((Object)clientProtocolStack.applicationProtocol(), (Matcher)Matchers.equalTo((Object)TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT)));
        Assert.assertThat((Object)clientProtocolStack.modifierProtocols(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldSuccessfullyHandshakeKnownProtocolOnServerNoModifiers() throws Exception {
        CompletableFuture clientFuture = this.handshakeClient.initiate((Channel)new SimpleNettyChannel(this.client.channel, (Log)NullLog.getInstance()), this.raftApplicationProtocolRepository, this.unsupportingModifierProtocolRepository);
        CompletableFuture<ProtocolStack> serverHandshakeFuture = this.getServerHandshakeFuture(clientFuture);
        ProtocolStack serverProtocolStack = serverHandshakeFuture.get(1L, TimeUnit.MINUTES);
        Assert.assertThat((Object)serverProtocolStack.applicationProtocol(), (Matcher)Matchers.equalTo((Object)TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT)));
        Assert.assertThat((Object)serverProtocolStack.modifierProtocols(), (Matcher)Matchers.empty());
    }

    @Test(expected=ClientHandshakeException.class)
    public void shouldFailHandshakeForUnknownProtocolOnClient() throws Throwable {
        CompletableFuture clientHandshakeFuture = this.handshakeClient.initiate((Channel)new SimpleNettyChannel(this.client.channel, (Log)NullLog.getInstance()), this.catchupApplicationProtocolRepository, this.compressionModifierProtocolRepository);
        try {
            clientHandshakeFuture.get(1L, TimeUnit.MINUTES);
        }
        catch (ExecutionException ex) {
            throw ex.getCause();
        }
    }

    @Test(expected=ServerHandshakeException.class)
    public void shouldFailHandshakeForUnknownProtocolOnServer() throws Throwable {
        CompletableFuture clientFuture = this.handshakeClient.initiate((Channel)new SimpleNettyChannel(this.client.channel, (Log)NullLog.getInstance()), this.catchupApplicationProtocolRepository, this.compressionModifierProtocolRepository);
        CompletableFuture<ProtocolStack> serverHandshakeFuture = this.getServerHandshakeFuture(clientFuture);
        try {
            serverHandshakeFuture.get(1L, TimeUnit.MINUTES);
        }
        catch (ExecutionException ex) {
            throw ex.getCause();
        }
    }

    private CompletableFuture<ProtocolStack> getServerHandshakeFuture(CompletableFuture<ProtocolStack> clientFuture) {
        return ((CompletableFuture)clientFuture.handle((ignoreSuccess, ignoreFailure) -> null)).thenCompose(ignored -> this.server.handshakeServer.protocolStackFuture());
    }

    static class ClientInitializer
    extends ChannelInitializer<SocketChannel> {
        private final HandshakeClient handshakeClient;

        ClientInitializer(HandshakeClient handshakeClient) {
            this.handshakeClient = handshakeClient;
        }

        protected void initChannel(SocketChannel channel) {
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
            pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));
            pipeline.addLast("requestMessageEncoder", (ChannelHandler)new ClientMessageEncoder());
            pipeline.addLast("responseMessageDecoder", (ChannelHandler)new ClientMessageDecoder());
            pipeline.addLast(new ChannelHandler[]{new NettyHandshakeClient(this.handshakeClient)});
        }
    }

    private static class Client {
        Bootstrap bootstrap;
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
        io.netty.channel.Channel channel;

        Client(HandshakeClient handshakeClient) {
            this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ClientInitializer(handshakeClient));
        }

        void connect(int port) {
            ChannelFuture channelFuture = this.bootstrap.connect("localhost", port).awaitUninterruptibly();
            this.channel = channelFuture.channel();
        }

        void disconnect() {
            if (this.channel != null) {
                this.channel.close().awaitUninterruptibly();
                this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            }
        }
    }

    private static class Server {
        io.netty.channel.Channel channel;
        NioEventLoopGroup eventLoopGroup;
        HandshakeServer handshakeServer;

        private Server() {
        }

        void start(final ApplicationProtocolRepository applicationProtocolRepository, final ModifierProtocolRepository modifierProtocolRepository) {
            this.eventLoopGroup = new NioEventLoopGroup();
            ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)this.eventLoopGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).localAddress(0)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    handshakeServer = new HandshakeServer(applicationProtocolRepository, modifierProtocolRepository, (Channel)new SimpleNettyChannel((io.netty.channel.Channel)ch, (Log)NullLog.getInstance()));
                    pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
                    pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));
                    pipeline.addLast("responseMessageEncoder", (ChannelHandler)new ServerMessageEncoder());
                    pipeline.addLast("requestMessageDecoder", (ChannelHandler)new ServerMessageDecoder());
                    pipeline.addLast(new ChannelHandler[]{new NettyHandshakeServer(handshakeServer)});
                }
            });
            this.channel = bootstrap.bind().syncUninterruptibly().channel();
        }

        void stop() {
            this.channel.close().awaitUninterruptibly();
            this.channel = null;
            this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }

        int port() {
            return ((InetSocketAddress)this.channel.localAddress()).getPort();
        }
    }
}

