/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.messaging.Channel;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.HandshakeServer;
import org.neo4j.causalclustering.protocol.handshake.InitialMagicMessage;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.causalclustering.protocol.handshake.ServerHandshakeException;
import org.neo4j.causalclustering.protocol.handshake.StatusCode;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverRequest;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverResponse;
import org.neo4j.causalclustering.protocol.handshake.TestProtocols;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;

public class HandshakeServerTest {
    private Channel channel = (Channel)Mockito.mock(Channel.class);
    private ApplicationSupportedProtocols supportedApplicationProtocol = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, Collections.emptyList());
    private Collection<ModifierSupportedProtocols> supportedModifierProtocols = Arrays.asList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, TestProtocols.TestModifierProtocols.listVersionsOf(Protocol.ModifierProtocolCategory.COMPRESSION)), new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION, TestProtocols.TestModifierProtocols.listVersionsOf(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION)));
    private ApplicationProtocolRepository applicationProtocolRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])TestProtocols.TestApplicationProtocols.values(), this.supportedApplicationProtocol);
    private ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), this.supportedModifierProtocols);
    private HandshakeServer server = new HandshakeServer(this.applicationProtocolRepository, this.modifierProtocolRepository, this.channel);

    @Test
    public void shouldDeclineUnallowedApplicationProtocol() {
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(TestProtocols.TestApplicationProtocols.CATCHUP_1.category(), Iterators.asSet((Object[])new Integer[]{TestProtocols.TestApplicationProtocols.CATCHUP_1.implementation()})));
        ((Channel)Mockito.verify((Object)this.channel)).dispose();
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackOnUnallowedApplicationProtocol() {
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(TestProtocols.TestApplicationProtocols.CATCHUP_1.category(), Iterators.asSet((Object[])new Integer[]{TestProtocols.TestApplicationProtocols.CATCHUP_1.implementation()})));
        this.assertExceptionallyCompletedProtocolStackFuture();
    }

    @Test
    public void shouldDisconnectOnWrongMagicValue() {
        this.server.handle(new InitialMagicMessage("PLAIN_VALUE"));
        ((Channel)Mockito.verify((Object)this.channel)).dispose();
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackOnWrongMagicValue() {
        this.server.handle(new InitialMagicMessage("PLAIN_VALUE"));
        this.assertExceptionallyCompletedProtocolStackFuture();
    }

    @Test
    public void shouldAcceptCorrectMagicValue() {
        this.server.handle(InitialMagicMessage.instance());
        this.assertUnfinished();
    }

    @Test
    public void shouldSendApplicationProtocolResponseForKnownProtocol() {
        Set versions = Iterators.asSet((Object[])new Integer[]{1, 2, 3});
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), versions));
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)new ApplicationProtocolResponse(StatusCode.SUCCESS, TestProtocols.TestApplicationProtocols.RAFT_3.category(), TestProtocols.TestApplicationProtocols.RAFT_3.implementation().intValue()));
    }

    @Test
    public void shouldNotCloseConnectionIfKnownApplicationProtocol() {
        Set versions = Iterators.asSet((Object[])new Integer[]{1, 2, 3});
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), versions));
        this.assertUnfinished();
    }

    @Test
    public void shouldSendNegativeResponseAndCloseForUnknownApplicationProtocol() {
        Set versions = Iterators.asSet((Object[])new Integer[]{1, 2, 3});
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest("UNKNOWN", versions));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.channel});
        ((Channel)inOrder.verify((Object)this.channel)).writeAndFlush((Object)ApplicationProtocolResponse.NO_PROTOCOL);
        ((Channel)inOrder.verify((Object)this.channel)).dispose();
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackForUnknownApplicationProtocol() {
        Set versions = Iterators.asSet((Object[])new Integer[]{1, 2, 3});
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest("UNKNOWN", versions));
        this.assertExceptionallyCompletedProtocolStackFuture();
    }

    @Test
    public void shouldSendModifierProtocolResponseForGivenProtocol() {
        Set versions = Iterators.asSet((Object[])TestProtocols.TestModifierProtocols.allVersionsOf(Protocol.ModifierProtocolCategory.COMPRESSION));
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), versions));
        Protocol.ModifierProtocol expected = TestProtocols.TestModifierProtocols.latest(Protocol.ModifierProtocolCategory.COMPRESSION);
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)new ModifierProtocolResponse(StatusCode.SUCCESS, expected.category(), (String)((Object)expected.implementation())));
    }

    @Test
    public void shouldNotCloseConnectionForGivenModifierProtocol() {
        Set versions = Iterators.asSet((Object[])new String[]{TestProtocols.TestModifierProtocols.SNAPPY.implementation(), TestProtocols.TestModifierProtocols.LZO.implementation(), TestProtocols.TestModifierProtocols.LZ4.implementation()});
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), versions));
        this.assertUnfinished();
    }

    @Test
    public void shouldSendFailModifierProtocolResponseForUnknownVersion() {
        Set versions = Iterators.asSet((Object[])new String[]{"Not a real protocol"});
        this.server.handle(InitialMagicMessage.instance());
        String protocolName = Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName();
        this.server.handle(new ModifierProtocolRequest(protocolName, versions));
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)new ModifierProtocolResponse(StatusCode.FAILURE, protocolName, ""));
    }

    @Test
    public void shouldNotCloseConnectionIfUnknownModifierProtocolVersion() {
        Set versions = Iterators.asSet((Object[])new String[]{"not a real algorithm"});
        this.server.handle(InitialMagicMessage.instance());
        String protocolName = Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName();
        this.server.handle(new ModifierProtocolRequest(protocolName, versions));
        this.assertUnfinished();
    }

    @Test
    public void shouldSendFailModifierProtocolResponseForUnknownProtocol() {
        Set versions = Iterators.asSet((Object[])new String[]{TestProtocols.TestModifierProtocols.SNAPPY.implementation(), TestProtocols.TestModifierProtocols.LZO.implementation(), TestProtocols.TestModifierProtocols.LZ4.implementation()});
        this.server.handle(InitialMagicMessage.instance());
        String protocolName = "let's just randomly reorder all the bytes";
        this.server.handle(new ModifierProtocolRequest(protocolName, versions));
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)new ModifierProtocolResponse(StatusCode.FAILURE, protocolName, ""));
    }

    @Test
    public void shouldNotCloseConnectionIfUnknownModifierProtocol() {
        Set versions = Iterators.asSet((Object[])new String[]{TestProtocols.TestModifierProtocols.SNAPPY.implementation(), TestProtocols.TestModifierProtocols.LZO.implementation(), TestProtocols.TestModifierProtocols.LZ4.implementation()});
        this.server.handle(InitialMagicMessage.instance());
        String protocolName = "let's just randomly reorder all the bytes";
        this.server.handle(new ModifierProtocolRequest(protocolName, versions));
        this.assertUnfinished();
    }

    @Test
    public void shouldSendFailureOnUnknownProtocolSwitchOver() {
        int version = 1;
        String unknownProtocolName = "UNKNOWN";
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(unknownProtocolName, Iterators.asSet((Object[])new Integer[]{version})));
        this.server.handle(new SwitchOverRequest(unknownProtocolName, version, Collections.emptyList()));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.channel});
        ((Channel)inOrder.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverResponse(StatusCode.FAILURE));
        ((Channel)inOrder.verify((Object)this.channel)).dispose();
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackOnUnknownProtocolSwitchOver() {
        int version = 1;
        String unknownProtocolName = "UNKNOWN";
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(unknownProtocolName, Iterators.asSet((Object[])new Integer[]{version})));
        this.server.handle(new SwitchOverRequest(unknownProtocolName, version, Collections.emptyList()));
        this.assertExceptionallyCompletedProtocolStackFuture();
    }

    @Test
    public void shouldSendFailureIfSwitchOverBeforeNegotiation() {
        int version = 1;
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new SwitchOverRequest(TestProtocols.TestApplicationProtocols.RAFT_1.category(), version, Collections.emptyList()));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.channel});
        ((Channel)inOrder.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverResponse(StatusCode.FAILURE));
        ((Channel)inOrder.verify((Object)this.channel)).dispose();
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackIfSwitchOverBeforeNegotiation() {
        int version = 1;
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new SwitchOverRequest(TestProtocols.TestApplicationProtocols.RAFT_1.category(), version, Collections.emptyList()));
        this.assertExceptionallyCompletedProtocolStackFuture();
    }

    @Test
    public void shouldSendFailureIfSwitchOverDiffersFromNegotiatedProtocol() {
        int version = 1;
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{version})));
        this.server.handle(new SwitchOverRequest(TestProtocols.TestApplicationProtocols.RAFT_1.category(), version + 1, Collections.emptyList()));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.channel});
        ((Channel)inOrder.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverResponse(StatusCode.FAILURE));
        ((Channel)inOrder.verify((Object)this.channel)).dispose();
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackIfSwitchOverDiffersFromNegotiatedProtocol() {
        int version = 1;
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{version})));
        this.server.handle(new SwitchOverRequest(TestProtocols.TestApplicationProtocols.RAFT_1.category(), version + 1, Collections.emptyList()));
        this.assertExceptionallyCompletedProtocolStackFuture();
    }

    @Test
    public void shouldSendFailureIfSwitchOverDiffersByNameFromNegotiatedModifierProtocol() {
        String modifierVersion = TestProtocols.TestModifierProtocols.ROT13.implementation();
        int applicationVersion = 1;
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{applicationVersion})));
        this.server.handle(new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), Iterators.asSet((Object[])new String[]{modifierVersion})));
        this.server.handle(new SwitchOverRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), applicationVersion, Arrays.asList(Pair.of((Object)Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION.canonicalName(), (Object)modifierVersion))));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.channel});
        ((Channel)inOrder.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverResponse(StatusCode.FAILURE));
        ((Channel)inOrder.verify((Object)this.channel)).dispose();
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackIfSwitchOverDiffersByNameFromNegotiatedModifiedProtocol() {
        String modifierVersion = TestProtocols.TestModifierProtocols.ROT13.implementation();
        int applicationVersion = 1;
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{applicationVersion})));
        this.server.handle(new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), Iterators.asSet((Object[])new String[]{modifierVersion})));
        this.server.handle(new SwitchOverRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), applicationVersion, Arrays.asList(Pair.of((Object)Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION.canonicalName(), (Object)modifierVersion))));
        this.assertExceptionallyCompletedProtocolStackFuture();
    }

    @Test
    public void shouldSendFailureIfSwitchOverChangesOrderOfModifierProtocols() {
        int version = 1;
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{version})));
        this.server.handle(new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), Iterators.asSet((Object[])new String[]{TestProtocols.TestModifierProtocols.SNAPPY.implementation()})));
        this.server.handle(new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION.canonicalName(), Iterators.asSet((Object[])new String[]{TestProtocols.TestModifierProtocols.ROT13.implementation()})));
        this.server.handle(new SwitchOverRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), version, Arrays.asList(Pair.of((Object)Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION.canonicalName(), (Object)TestProtocols.TestModifierProtocols.ROT13.implementation()), Pair.of((Object)Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), (Object)TestProtocols.TestModifierProtocols.SNAPPY.implementation()))));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.channel});
        ((Channel)inOrder.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverResponse(StatusCode.FAILURE));
        ((Channel)inOrder.verify((Object)this.channel)).dispose();
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackIfSwitchOverChangesOrderOfModifierProtocols() {
        int version = 1;
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{version})));
        this.server.handle(new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), Iterators.asSet((Object[])new String[]{TestProtocols.TestModifierProtocols.SNAPPY.implementation()})));
        this.server.handle(new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION.canonicalName(), Iterators.asSet((Object[])new String[]{TestProtocols.TestModifierProtocols.ROT13.implementation()})));
        this.server.handle(new SwitchOverRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), version, Arrays.asList(Pair.of((Object)Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION.canonicalName(), (Object)TestProtocols.TestModifierProtocols.ROT13.implementation()), Pair.of((Object)Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), (Object)TestProtocols.TestModifierProtocols.SNAPPY.implementation()))));
        this.assertExceptionallyCompletedProtocolStackFuture();
    }

    @Test
    public void shouldSendFailureIfSwitchOverDiffersByVersionFromNegotiatedModifierProtocol() {
        int version = 1;
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{version})));
        this.server.handle(new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), Iterators.asSet((Object[])new String[]{TestProtocols.TestModifierProtocols.SNAPPY.implementation()})));
        this.server.handle(new SwitchOverRequest(TestProtocols.TestApplicationProtocols.RAFT_1.category(), version, Arrays.asList(Pair.of((Object)Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), (Object)TestProtocols.TestModifierProtocols.LZ4.implementation()))));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.channel});
        ((Channel)inOrder.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverResponse(StatusCode.FAILURE));
        ((Channel)inOrder.verify((Object)this.channel)).dispose();
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackIfSwitchOverDiffersByVersionFromNegotiatedModifiedProtocol() {
        int version = 1;
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{version})));
        this.server.handle(new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), Iterators.asSet((Object[])new String[]{TestProtocols.TestModifierProtocols.SNAPPY.implementation()})));
        this.server.handle(new SwitchOverRequest(TestProtocols.TestApplicationProtocols.RAFT_1.category(), version, Arrays.asList(Pair.of((Object)Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), (Object)TestProtocols.TestModifierProtocols.LZ4.implementation()))));
        this.assertExceptionallyCompletedProtocolStackFuture();
    }

    @Test
    public void shouldCompleteProtocolStackOnSuccessfulSwitchOverWithNoModifierProtocols() {
        int version = 1;
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{version})));
        this.server.handle(new SwitchOverRequest(TestProtocols.TestApplicationProtocols.RAFT_1.category(), version, Collections.emptyList()));
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)InitialMagicMessage.instance());
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverResponse(StatusCode.SUCCESS));
        ProtocolStack protocolStack = this.server.protocolStackFuture().getNow(null);
        Assert.assertThat((Object)protocolStack, (Matcher)Matchers.equalTo((Object)new ProtocolStack((Protocol.ApplicationProtocol)TestProtocols.TestApplicationProtocols.RAFT_1, Collections.emptyList())));
    }

    @Test
    public void shouldCompleteProtocolStackOnSuccessfulSwitchOverWithModifierProtocols() {
        this.server.handle(InitialMagicMessage.instance());
        this.server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{TestProtocols.TestApplicationProtocols.RAFT_1.implementation()})));
        this.server.handle(new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), Iterators.asSet((Object[])new String[]{TestProtocols.TestModifierProtocols.SNAPPY.implementation()})));
        this.server.handle(new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION.canonicalName(), Iterators.asSet((Object[])new String[]{TestProtocols.TestModifierProtocols.ROT13.implementation()})));
        List<Pair> modifierRequest = Arrays.asList(Pair.of((Object)TestProtocols.TestModifierProtocols.SNAPPY.category(), (Object)TestProtocols.TestModifierProtocols.SNAPPY.implementation()), Pair.of((Object)TestProtocols.TestModifierProtocols.ROT13.category(), (Object)TestProtocols.TestModifierProtocols.ROT13.implementation()));
        this.server.handle(new SwitchOverRequest(TestProtocols.TestApplicationProtocols.RAFT_1.category(), TestProtocols.TestApplicationProtocols.RAFT_1.implementation().intValue(), modifierRequest));
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)InitialMagicMessage.instance());
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverResponse(StatusCode.SUCCESS));
        ProtocolStack protocolStack = this.server.protocolStackFuture().getNow(null);
        List<Protocol.ModifierProtocol> modifiers = Arrays.asList(new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.SNAPPY, TestProtocols.TestModifierProtocols.ROT13});
        Assert.assertThat((Object)protocolStack, (Matcher)Matchers.equalTo((Object)new ProtocolStack((Protocol.ApplicationProtocol)TestProtocols.TestApplicationProtocols.RAFT_1, modifiers)));
    }

    @Test
    public void shouldCompleteProtocolStackOnSuccessfulSwitchOverWithConfiguredModifierProtocols() {
        Set requestedVersions = Iterators.asSet((Object[])TestProtocols.TestModifierProtocols.allVersionsOf(Protocol.ModifierProtocolCategory.COMPRESSION));
        String expectedNegotiatedVersion = TestProtocols.TestModifierProtocols.SNAPPY.implementation();
        List<String> configuredVersions = Collections.singletonList(expectedNegotiatedVersion);
        List<ModifierSupportedProtocols> supportedModifierProtocols = Arrays.asList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, configuredVersions));
        ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), supportedModifierProtocols);
        HandshakeServer server = new HandshakeServer(this.applicationProtocolRepository, modifierProtocolRepository, this.channel);
        server.handle(InitialMagicMessage.instance());
        server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{TestProtocols.TestApplicationProtocols.RAFT_1.implementation()})));
        server.handle(new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), requestedVersions));
        List<Pair> modifierRequest = Arrays.asList(Pair.of((Object)TestProtocols.TestModifierProtocols.SNAPPY.category(), (Object)TestProtocols.TestModifierProtocols.SNAPPY.implementation()));
        server.handle(new SwitchOverRequest(TestProtocols.TestApplicationProtocols.RAFT_1.category(), TestProtocols.TestApplicationProtocols.RAFT_1.implementation().intValue(), modifierRequest));
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)InitialMagicMessage.instance());
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverResponse(StatusCode.SUCCESS));
        ProtocolStack protocolStack = server.protocolStackFuture().getNow(null);
        List<Protocol.ModifierProtocol> modifiers = Arrays.asList(new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.SNAPPY});
        Assert.assertThat((Object)protocolStack, (Matcher)Matchers.equalTo((Object)new ProtocolStack((Protocol.ApplicationProtocol)TestProtocols.TestApplicationProtocols.RAFT_1, modifiers)));
    }

    @Test
    public void shouldSuccessfullySwitchOverWhenServerHasConfiguredRaftVersions() {
        Set requestedVersions = Iterators.asSet((Object[])TestProtocols.TestApplicationProtocols.allVersionsOf(Protocol.ApplicationProtocolCategory.RAFT));
        Integer expectedNegotiatedVersion = 1;
        ApplicationProtocolRepository applicationProtocolRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])TestProtocols.TestApplicationProtocols.values(), new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, Collections.singletonList(expectedNegotiatedVersion)));
        HandshakeServer server = new HandshakeServer(applicationProtocolRepository, this.modifierProtocolRepository, this.channel);
        server.handle(InitialMagicMessage.instance());
        server.handle(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), requestedVersions));
        server.handle(new SwitchOverRequest(TestProtocols.TestApplicationProtocols.RAFT_1.category(), expectedNegotiatedVersion.intValue(), Collections.emptyList()));
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)InitialMagicMessage.instance());
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverResponse(StatusCode.SUCCESS));
        ProtocolStack protocolStack = server.protocolStackFuture().getNow(null);
        ProtocolStack expectedProtocolStack = new ProtocolStack((Protocol.ApplicationProtocol)applicationProtocolRepository.select(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), (Comparable)expectedNegotiatedVersion).get(), Collections.emptyList());
        Assert.assertThat((Object)protocolStack, (Matcher)Matchers.equalTo((Object)expectedProtocolStack));
    }

    private void assertUnfinished() {
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.never())).dispose();
        Assert.assertFalse((boolean)this.server.protocolStackFuture().isDone());
    }

    private void assertExceptionallyCompletedProtocolStackFuture() {
        Assert.assertTrue((boolean)this.server.protocolStackFuture().isCompletedExceptionally());
        try {
            this.server.protocolStackFuture().getNow(null);
        }
        catch (CompletionException ex) {
            Assert.assertThat((Object)ex.getCause(), (Matcher)Matchers.instanceOf(ServerHandshakeException.class));
        }
    }
}

