/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.messaging.Channel;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ClientHandshakeException;
import org.neo4j.causalclustering.protocol.handshake.HandshakeClient;
import org.neo4j.causalclustering.protocol.handshake.InitialMagicMessage;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.causalclustering.protocol.handshake.StatusCode;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverRequest;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverResponse;
import org.neo4j.causalclustering.protocol.handshake.TestProtocols;
import org.neo4j.helpers.collection.Pair;

public class HandshakeClientTest {
    private HandshakeClient client = new HandshakeClient();
    private Channel channel = (Channel)Mockito.mock(Channel.class);
    private Protocol.ApplicationProtocolCategory applicationProtocolIdentifier = Protocol.ApplicationProtocolCategory.RAFT;
    private ApplicationSupportedProtocols supportedApplicationProtocol = new ApplicationSupportedProtocols((Protocol.Category)this.applicationProtocolIdentifier, Collections.emptyList());
    private Collection<ModifierSupportedProtocols> supportedModifierProtocols = Stream.of(Protocol.ModifierProtocolCategory.values()).map(id -> new ModifierSupportedProtocols((Protocol.Category)id, Collections.emptyList())).collect(Collectors.toList());
    private ApplicationProtocolRepository applicationProtocolRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])TestProtocols.TestApplicationProtocols.values(), this.supportedApplicationProtocol);
    private ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), this.supportedModifierProtocols);
    private int raftVersion = (Integer)TestProtocols.TestApplicationProtocols.latest(Protocol.ApplicationProtocolCategory.RAFT).implementation();
    private Protocol.ApplicationProtocol expectedApplicationProtocol = (Protocol.ApplicationProtocol)this.applicationProtocolRepository.select(this.applicationProtocolIdentifier.canonicalName(), (Comparable)Integer.valueOf(this.raftVersion)).get();

    @Test
    public void shouldSendInitialMagicOnInitiation() {
        this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        ((Channel)Mockito.verify((Object)this.channel)).write((Object)InitialMagicMessage.instance());
    }

    @Test
    public void shouldSendApplicationProtocolRequestOnInitiation() {
        this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        ApplicationProtocolRequest expectedMessage = new ApplicationProtocolRequest(this.applicationProtocolIdentifier.canonicalName(), this.applicationProtocolRepository.getAll((Protocol.Category)this.applicationProtocolIdentifier, Collections.emptyList()).versions());
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)expectedMessage);
    }

    @Test
    public void shouldSendModifierProtocolRequestsOnInitiation() {
        this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        Stream.of(Protocol.ModifierProtocolCategory.values()).forEach(modifierProtocolIdentifier -> {
            Set versions = this.modifierProtocolRepository.getAll((Protocol.Category)modifierProtocolIdentifier, Collections.emptyList()).versions();
            ((Channel)Mockito.verify((Object)this.channel)).write((Object)new ModifierProtocolRequest(modifierProtocolIdentifier.canonicalName(), versions));
        });
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackOnReceivingIncorrectMagic() {
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        this.client.handle(new InitialMagicMessage("totally legit"));
        this.assertCompletedExceptionally(protocolStackCompletableFuture);
    }

    @Test
    public void shouldAcceptCorrectMagic() {
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        this.client.handle(InitialMagicMessage.instance());
        Assert.assertFalse((boolean)protocolStackCompletableFuture.isDone());
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackWhenApplicationProtocolResponseNotSuccessful() {
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        this.client.handle(InitialMagicMessage.instance());
        this.client.handle(new ApplicationProtocolResponse(StatusCode.FAILURE, this.applicationProtocolIdentifier.canonicalName(), this.raftVersion));
        this.assertCompletedExceptionally(protocolStackCompletableFuture);
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackWhenApplicationProtocolResponseForIncorrectProtocol() {
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        this.client.handle(InitialMagicMessage.instance());
        this.client.handle(new ApplicationProtocolResponse(StatusCode.SUCCESS, "zab", this.raftVersion));
        this.assertCompletedExceptionally(protocolStackCompletableFuture);
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackWhenApplicationProtocolResponseForUnsupportedVersion() {
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        this.client.handle(InitialMagicMessage.instance());
        this.client.handle(new ApplicationProtocolResponse(StatusCode.SUCCESS, this.applicationProtocolIdentifier.canonicalName(), Integer.MAX_VALUE));
        this.assertCompletedExceptionally(protocolStackCompletableFuture);
    }

    @Test
    public void shouldSendSwitchOverRequestIfNoModifierProtocolsToRequestOnApplicationProtocolResponse() {
        ModifierProtocolRepository repo = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), Collections.emptyList());
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, repo);
        this.client.handle(InitialMagicMessage.instance());
        this.client.handle(new ApplicationProtocolResponse(StatusCode.SUCCESS, this.applicationProtocolIdentifier.canonicalName(), this.raftVersion));
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverRequest(this.applicationProtocolIdentifier.canonicalName(), this.raftVersion, Collections.emptyList()));
        Assert.assertFalse((boolean)protocolStackCompletableFuture.isDone());
    }

    @Test
    public void shouldNotSendSwitchOverRequestOnModifierProtocolResponseIfNotAllModifierProtocolResponsesReceived() {
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        this.client.handle(InitialMagicMessage.instance());
        this.client.handle(new ApplicationProtocolResponse(StatusCode.SUCCESS, this.applicationProtocolIdentifier.canonicalName(), this.raftVersion));
        this.client.handle(new ModifierProtocolResponse(StatusCode.SUCCESS, Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), "woot"));
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.never())).writeAndFlush((Object)Matchers.any(SwitchOverRequest.class));
        Assert.assertFalse((boolean)protocolStackCompletableFuture.isDone());
    }

    @Test
    public void shouldNotSendSwitchOverRequestIfApplicationProtocolResponseNotReceivedOnModifierProtocolResponseReceive() {
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        this.client.handle(InitialMagicMessage.instance());
        this.client.handle(new ModifierProtocolResponse(StatusCode.SUCCESS, Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), TestProtocols.TestModifierProtocols.SNAPPY.implementation()));
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.never())).writeAndFlush((Object)Matchers.any(SwitchOverRequest.class));
        Assert.assertFalse((boolean)protocolStackCompletableFuture.isDone());
    }

    @Test
    public void shouldSendSwitchOverRequestOnModifierProtocolResponseIfAllModifierProtocolResponsesReceived() {
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        this.client.handle(InitialMagicMessage.instance());
        this.client.handle(new ApplicationProtocolResponse(StatusCode.SUCCESS, this.applicationProtocolIdentifier.canonicalName(), this.raftVersion));
        this.client.handle(new ModifierProtocolResponse(StatusCode.SUCCESS, Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), TestProtocols.TestModifierProtocols.SNAPPY.implementation()));
        this.client.handle(new ModifierProtocolResponse(StatusCode.SUCCESS, Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION.canonicalName(), TestProtocols.TestModifierProtocols.ROT13.implementation()));
        List<Pair> switchOverModifierProtocols = Arrays.asList(Pair.of((Object)Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), (Object)TestProtocols.TestModifierProtocols.SNAPPY.implementation()), Pair.of((Object)Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION.canonicalName(), (Object)TestProtocols.TestModifierProtocols.ROT13.implementation()));
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverRequest(this.applicationProtocolIdentifier.canonicalName(), this.raftVersion, switchOverModifierProtocols));
        Assert.assertFalse((boolean)protocolStackCompletableFuture.isDone());
    }

    @Test
    public void shouldNotIncludeModifierProtocolInSwitchOverRequestIfNotSuccessful() {
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        this.client.handle(InitialMagicMessage.instance());
        this.client.handle(new ApplicationProtocolResponse(StatusCode.SUCCESS, this.applicationProtocolIdentifier.canonicalName(), this.raftVersion));
        this.client.handle(new ModifierProtocolResponse(StatusCode.SUCCESS, Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), TestProtocols.TestModifierProtocols.SNAPPY.implementation()));
        this.client.handle(new ModifierProtocolResponse(StatusCode.FAILURE, Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION.canonicalName(), TestProtocols.TestModifierProtocols.ROT13.implementation()));
        List<Pair> switchOverModifierProtocols = Arrays.asList(Pair.of((Object)Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), (Object)TestProtocols.TestModifierProtocols.SNAPPY.implementation()));
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverRequest(this.applicationProtocolIdentifier.canonicalName(), this.raftVersion, switchOverModifierProtocols));
        Assert.assertFalse((boolean)protocolStackCompletableFuture.isDone());
    }

    @Test
    public void shouldNotIncludeModifierProtocolInSwitchOverRequestIfUnsupportedProtocol() {
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        this.client.handle(InitialMagicMessage.instance());
        this.client.handle(new ApplicationProtocolResponse(StatusCode.SUCCESS, this.applicationProtocolIdentifier.canonicalName(), this.raftVersion));
        this.client.handle(new ModifierProtocolResponse(StatusCode.SUCCESS, Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), TestProtocols.TestModifierProtocols.SNAPPY.implementation()));
        this.client.handle(new ModifierProtocolResponse(StatusCode.SUCCESS, "not a protocol", "not an implementation"));
        List<Pair> switchOverModifierProtocols = Arrays.asList(Pair.of((Object)Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), (Object)TestProtocols.TestModifierProtocols.SNAPPY.implementation()));
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverRequest(this.applicationProtocolIdentifier.canonicalName(), this.raftVersion, switchOverModifierProtocols));
        Assert.assertFalse((boolean)protocolStackCompletableFuture.isDone());
    }

    @Test
    public void shouldNotIncludeModifierProtocolInSwitchOverRequestIfUnsupportedVersion() {
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        this.client.handle(InitialMagicMessage.instance());
        this.client.handle(new ApplicationProtocolResponse(StatusCode.SUCCESS, this.applicationProtocolIdentifier.canonicalName(), this.raftVersion));
        this.client.handle(new ModifierProtocolResponse(StatusCode.SUCCESS, Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), TestProtocols.TestModifierProtocols.SNAPPY.implementation()));
        this.client.handle(new ModifierProtocolResponse(StatusCode.SUCCESS, Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION.canonicalName(), "Rearrange the bytes at random"));
        List<Pair> switchOverModifierProtocols = Arrays.asList(Pair.of((Object)Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), (Object)TestProtocols.TestModifierProtocols.SNAPPY.implementation()));
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)new SwitchOverRequest(this.applicationProtocolIdentifier.canonicalName(), this.raftVersion, switchOverModifierProtocols));
        Assert.assertFalse((boolean)protocolStackCompletableFuture.isDone());
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackWhenSwitchOverResponseNotSuccess() {
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        this.client.handle(InitialMagicMessage.instance());
        this.client.handle(new ApplicationProtocolResponse(StatusCode.SUCCESS, this.applicationProtocolIdentifier.canonicalName(), this.raftVersion));
        this.client.handle(new SwitchOverResponse(StatusCode.FAILURE));
        this.assertCompletedExceptionally(protocolStackCompletableFuture);
    }

    @Test
    public void shouldExceptionallyCompleteProtocolStackWhenProtocolStackNotSet() {
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
        this.client.handle(InitialMagicMessage.instance());
        this.client.handle(new SwitchOverResponse(StatusCode.SUCCESS));
        this.assertCompletedExceptionally(protocolStackCompletableFuture);
    }

    @Test
    public void shouldCompleteProtocolStackOnSwitchoverResponse() {
        ModifierProtocolRepository repo = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), Arrays.asList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, Collections.emptyList())));
        CompletableFuture protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, repo);
        this.client.handle(InitialMagicMessage.instance());
        this.client.handle(new ApplicationProtocolResponse(StatusCode.SUCCESS, this.applicationProtocolIdentifier.canonicalName(), this.raftVersion));
        this.client.handle(new ModifierProtocolResponse(StatusCode.SUCCESS, TestProtocols.TestModifierProtocols.SNAPPY.category(), TestProtocols.TestModifierProtocols.SNAPPY.implementation()));
        this.client.handle(new SwitchOverResponse(StatusCode.SUCCESS));
        ProtocolStack protocolStack = protocolStackCompletableFuture.getNow(null);
        Assert.assertThat((Object)protocolStack, (Matcher)Matchers.equalTo((Object)new ProtocolStack(this.expectedApplicationProtocol, Collections.singletonList(TestProtocols.TestModifierProtocols.SNAPPY))));
    }

    private void assertCompletedExceptionally(CompletableFuture<ProtocolStack> protocolStackCompletableFuture) {
        Assert.assertTrue((boolean)protocolStackCompletableFuture.isCompletedExceptionally());
        try {
            protocolStackCompletableFuture.getNow(null);
        }
        catch (CompletionException ex) {
            Assert.assertThat((Object)ex.getCause(), (Matcher)Matchers.instanceOf(ClientHandshakeException.class));
        }
    }
}

