/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.protocol.v1.RaftProtocolClientInstallerV1;
import org.neo4j.causalclustering.core.consensus.protocol.v1.RaftProtocolServerInstallerV1;
import org.neo4j.causalclustering.handlers.VoidPipelineWrapperFactory;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.ProtocolInstallerRepository;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.causalclustering.protocol.handshake.TestProtocols;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class ProtocolInstallerRepositoryTest {
    private List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Client>> clientModifiers = Arrays.asList(new ModifierProtocolInstaller[]{new SnappyClientInstaller(), new LZOClientInstaller(), new LZ4ClientInstaller(), new LZ4HighCompressionClientInstaller(), new Rot13ClientInstaller()});
    private List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Server>> serverModifiers = Arrays.asList(new ModifierProtocolInstaller[]{new SnappyServerInstaller(), new LZOServerInstaller(), new LZ4ServerInstaller(), new LZ4ValidatingServerInstaller(), new Rot13ServerInstaller()});
    private final NettyPipelineBuilderFactory pipelineBuilderFactory = new NettyPipelineBuilderFactory(VoidPipelineWrapperFactory.VOID_WRAPPER);
    private final RaftProtocolClientInstallerV1.Factory raftProtocolClientInstaller = new RaftProtocolClientInstallerV1.Factory(this.pipelineBuilderFactory, (LogProvider)NullLogProvider.getInstance());
    private final RaftProtocolServerInstallerV1.Factory raftProtocolServerInstaller = new RaftProtocolServerInstallerV1.Factory(null, this.pipelineBuilderFactory, (LogProvider)NullLogProvider.getInstance());
    private final ProtocolInstallerRepository<ProtocolInstaller.Orientation.Client> clientRepository = new ProtocolInstallerRepository(Arrays.asList(this.raftProtocolClientInstaller), this.clientModifiers);
    private final ProtocolInstallerRepository<ProtocolInstaller.Orientation.Server> serverRepository = new ProtocolInstallerRepository(Arrays.asList(this.raftProtocolServerInstaller), this.serverModifiers);

    @Test
    public void shouldReturnRaftServerInstaller() {
        Assert.assertEquals((Object)this.raftProtocolServerInstaller.applicationProtocol(), (Object)this.serverRepository.installerFor(new ProtocolStack((Protocol.ApplicationProtocol)Protocol.ApplicationProtocols.RAFT_1, Collections.emptyList())).applicationProtocol());
    }

    @Test
    public void shouldReturnRaftClientInstaller() {
        Assert.assertEquals((Object)this.raftProtocolClientInstaller.applicationProtocol(), (Object)this.clientRepository.installerFor(new ProtocolStack((Protocol.ApplicationProtocol)Protocol.ApplicationProtocols.RAFT_1, Collections.emptyList())).applicationProtocol());
    }

    @Test
    public void shouldReturnModifierProtocolsForClient() {
        TestProtocols.TestModifierProtocols expected = TestProtocols.TestModifierProtocols.SNAPPY;
        ProtocolStack protocolStack = new ProtocolStack((Protocol.ApplicationProtocol)Protocol.ApplicationProtocols.RAFT_1, Arrays.asList(new Protocol.ModifierProtocol[]{expected}));
        Collection actual = this.clientRepository.installerFor(protocolStack).modifiers();
        Assert.assertThat((Object)actual, (Matcher)Matchers.contains((Matcher)Matchers.contains((Object[])new Protocol.ModifierProtocol[]{expected})));
    }

    @Test
    public void shouldReturnModifierProtocolsForServer() {
        TestProtocols.TestModifierProtocols expected = TestProtocols.TestModifierProtocols.SNAPPY;
        ProtocolStack protocolStack = new ProtocolStack((Protocol.ApplicationProtocol)Protocol.ApplicationProtocols.RAFT_1, Arrays.asList(new Protocol.ModifierProtocol[]{expected}));
        Collection actual = this.serverRepository.installerFor(protocolStack).modifiers();
        Assert.assertThat((Object)actual, (Matcher)Matchers.contains((Matcher)Matchers.contains((Object[])new Protocol.ModifierProtocol[]{expected})));
    }

    @Test
    public void shouldReturnModifierProtocolsForProtocolWithSharedInstallerForClient() {
        TestProtocols.TestModifierProtocols expected = TestProtocols.TestModifierProtocols.LZ4_HIGH_COMPRESSION_VALIDATING;
        TestProtocols.TestModifierProtocols alsoSupported = TestProtocols.TestModifierProtocols.LZ4_HIGH_COMPRESSION;
        ProtocolStack protocolStack = new ProtocolStack((Protocol.ApplicationProtocol)Protocol.ApplicationProtocols.RAFT_1, Arrays.asList(new Protocol.ModifierProtocol[]{expected}));
        Collection actual = this.clientRepository.installerFor(protocolStack).modifiers();
        Assert.assertThat((Object)actual, (Matcher)Matchers.contains((Matcher)Matchers.containsInAnyOrder((Object[])new Protocol.ModifierProtocol[]{expected, alsoSupported})));
    }

    @Test
    public void shouldReturnModifierProtocolsForProtocolWithSharedInstallerForServer() {
        TestProtocols.TestModifierProtocols expected = TestProtocols.TestModifierProtocols.LZ4_HIGH_COMPRESSION_VALIDATING;
        TestProtocols.TestModifierProtocols alsoSupported = TestProtocols.TestModifierProtocols.LZ4_VALIDATING;
        ProtocolStack protocolStack = new ProtocolStack((Protocol.ApplicationProtocol)Protocol.ApplicationProtocols.RAFT_1, Arrays.asList(new Protocol.ModifierProtocol[]{expected}));
        Collection actual = this.serverRepository.installerFor(protocolStack).modifiers();
        Assert.assertThat((Object)actual, (Matcher)Matchers.contains((Matcher)Matchers.containsInAnyOrder((Object[])new Protocol.ModifierProtocol[]{expected, alsoSupported})));
    }

    @Test
    public void shouldUseDifferentInstancesOfProtocolInstaller() {
        ProtocolStack protocolStack1 = new ProtocolStack((Protocol.ApplicationProtocol)Protocol.ApplicationProtocols.RAFT_1, Arrays.asList(new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.SNAPPY}));
        ProtocolStack protocolStack2 = new ProtocolStack((Protocol.ApplicationProtocol)Protocol.ApplicationProtocols.RAFT_1, Arrays.asList(new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.LZO}));
        ProtocolInstaller protocolInstaller1 = this.clientRepository.installerFor(protocolStack1);
        ProtocolInstaller protocolInstaller2 = this.clientRepository.installerFor(protocolStack2);
        Assert.assertThat((Object)protocolInstaller1, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)protocolInstaller2)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfAttemptingToCreateInstallerForMultipleModifiersWithSameIdentifier() {
        ProtocolStack protocolStack = new ProtocolStack((Protocol.ApplicationProtocol)Protocol.ApplicationProtocols.RAFT_1, Arrays.asList(new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.SNAPPY, TestProtocols.TestModifierProtocols.LZO}));
        this.clientRepository.installerFor(protocolStack);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInitialiseIfMultipleInstallersForSameProtocolForServer() {
        new ProtocolInstallerRepository(Arrays.asList(this.raftProtocolServerInstaller, this.raftProtocolServerInstaller), Collections.emptyList());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInitialiseIfMultipleInstallersForSameProtocolForClient() {
        new ProtocolInstallerRepository(Arrays.asList(this.raftProtocolClientInstaller, this.raftProtocolClientInstaller), Collections.emptyList());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIfUnknownProtocolForServer() {
        this.serverRepository.installerFor(new ProtocolStack((Protocol.ApplicationProtocol)TestProtocols.TestApplicationProtocols.RAFT_3, Collections.emptyList()));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIfUnknownProtocolForClient() {
        this.clientRepository.installerFor(new ProtocolStack((Protocol.ApplicationProtocol)TestProtocols.TestApplicationProtocols.RAFT_3, Collections.emptyList()));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIfUnknownModifierProtocol() {
        Protocol.ModifierProtocols unknownProtocol = Protocol.ModifierProtocols.COMPRESSION_SNAPPY;
        this.serverRepository.installerFor(new ProtocolStack((Protocol.ApplicationProtocol)Protocol.ApplicationProtocols.RAFT_1, Arrays.asList(unknownProtocol)));
    }

    private class Rot13ServerInstaller
    extends ModifierProtocolInstaller.BaseServerModifier {
        Rot13ServerInstaller() {
            super("rot13", null, new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.ROT13});
        }
    }

    private static class LZ4ValidatingServerInstaller
    extends ModifierProtocolInstaller.BaseServerModifier {
        private LZ4ValidatingServerInstaller() {
            super("lz4", null, new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.LZ4_VALIDATING, TestProtocols.TestModifierProtocols.LZ4_HIGH_COMPRESSION_VALIDATING});
        }
    }

    private static class LZ4ServerInstaller
    extends ModifierProtocolInstaller.BaseServerModifier {
        private LZ4ServerInstaller() {
            super("lz4", null, new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.LZ4, TestProtocols.TestModifierProtocols.LZ4_HIGH_COMPRESSION});
        }
    }

    private static class LZOServerInstaller
    extends ModifierProtocolInstaller.BaseServerModifier {
        private LZOServerInstaller() {
            super("lzo", null, new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.LZO});
        }
    }

    private static class SnappyServerInstaller
    extends ModifierProtocolInstaller.BaseServerModifier {
        private SnappyServerInstaller() {
            super("snappy", null, new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.SNAPPY});
        }
    }

    private class Rot13ClientInstaller
    extends ModifierProtocolInstaller.BaseClientModifier {
        Rot13ClientInstaller() {
            super("rot13", null, new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.ROT13});
        }
    }

    private static class LZ4HighCompressionClientInstaller
    extends ModifierProtocolInstaller.BaseClientModifier {
        private LZ4HighCompressionClientInstaller() {
            super("lz4", null, new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.LZ4_HIGH_COMPRESSION, TestProtocols.TestModifierProtocols.LZ4_HIGH_COMPRESSION_VALIDATING});
        }
    }

    private static class LZ4ClientInstaller
    extends ModifierProtocolInstaller.BaseClientModifier {
        private LZ4ClientInstaller() {
            super("lz4", null, new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.LZ4, TestProtocols.TestModifierProtocols.LZ4_VALIDATING});
        }
    }

    private static class LZOClientInstaller
    extends ModifierProtocolInstaller.BaseClientModifier {
        private LZOClientInstaller() {
            super("lzo", null, new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.LZO});
        }
    }

    private static class SnappyClientInstaller
    extends ModifierProtocolInstaller.BaseClientModifier {
        private SnappyClientInstaller() {
            super("snappy", null, new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.SNAPPY});
        }
    }
}

