/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2.decoding;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.messaging.marshalling.v2.decoding.RaftMessageComposer;
import org.neo4j.causalclustering.messaging.marshalling.v2.decoding.RaftMessageDecoder;

public class ClusterIdAwareMessageComposerTest {
    @Test
    public void shouldThrowExceptionOnConflictingMessageHeaders() {
        try {
            RaftMessageComposer raftMessageComposer = new RaftMessageComposer(Clock.systemUTC());
            raftMessageComposer.decode(null, (Object)this.messageCreator((a, b) -> Optional.empty()), null);
            raftMessageComposer.decode(null, (Object)this.messageCreator((a, b) -> Optional.empty()), null);
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Pipeline already contains message header waiting to build."));
            return;
        }
        Assertions.fail();
    }

    @Test
    public void shouldThrowExceptionIfNotAllResourcesAreUsed() {
        try {
            RaftMessageComposer raftMessageComposer = new RaftMessageComposer(Clock.systemUTC());
            ReplicatedTransaction replicatedTransaction = new ReplicatedTransaction(new byte[0]);
            raftMessageComposer.decode(null, (Object)replicatedTransaction, null);
            ArrayList out = new ArrayList();
            raftMessageComposer.decode(null, (Object)this.messageCreator((a, b) -> Optional.of(this.dummyRequest())), out);
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"was composed without using all resources in the pipeline. Pipeline still contains Replicated contents"));
            return;
        }
        Assertions.fail();
    }

    @Test
    public void shouldThrowExceptionIfUnrecognizedObjectIsFound() {
        try {
            RaftMessageComposer raftMessageComposer = new RaftMessageComposer(Clock.systemUTC());
            raftMessageComposer.decode(null, (Object)"a string", null);
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Unexpected object in the pipeline: a string"));
            return;
        }
        Assertions.fail();
    }

    private RaftMessages.PruneRequest dummyRequest() {
        return new RaftMessages.PruneRequest(1L);
    }

    private RaftMessageDecoder.ClusterIdAwareMessageComposer messageCreator(RaftMessageDecoder.LazyComposer composer) {
        return new RaftMessageDecoder.ClusterIdAwareMessageComposer(composer, new ClusterId(UUID.randomUUID()));
    }
}

