/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Collections;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.protocol.v2.RaftProtocolClientInstallerV2;
import org.neo4j.causalclustering.core.consensus.protocol.v2.RaftProtocolServerInstallerV2;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.LocalOperationId;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.TokenType;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.handlers.VoidPipelineWrapperFactory;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;

@RunWith(value=Parameterized.class)
public class RaftMessageEncoderDecoderTest {
    private static final MemberId MEMBER_ID = new MemberId(UUID.randomUUID());
    @Parameterized.Parameter
    public RaftMessages.RaftMessage raftMessage;
    private final RaftMessageHandler handler = new RaftMessageHandler();
    private EmbeddedChannel outbound;
    private EmbeddedChannel inbound;

    @Parameterized.Parameters(name="{0}")
    public static RaftMessages.RaftMessage[] data() {
        return new RaftMessages.RaftMessage[]{new RaftMessages.Heartbeat(MEMBER_ID, 1L, 2L, 3L), new RaftMessages.HeartbeatResponse(MEMBER_ID), new RaftMessages.NewEntry.Request(MEMBER_ID, (ReplicatedContent)new ReplicatedTransaction(new byte[]{1, 2, 3, 4, 5, 6, 7, 8})), new RaftMessages.NewEntry.Request(MEMBER_ID, (ReplicatedContent)new DistributedOperation((ReplicatedContent)new DistributedOperation((ReplicatedContent)new ReplicatedTransaction(new byte[]{1, 2, 3, 4, 5}), new GlobalSession(UUID.randomUUID(), MEMBER_ID), new LocalOperationId(1L, 2L)), new GlobalSession(UUID.randomUUID(), MEMBER_ID), new LocalOperationId(3L, 4L))), new RaftMessages.AppendEntries.Request(MEMBER_ID, 1L, 2L, 3L, new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new ReplicatedTokenRequest(TokenType.LABEL, "name", new byte[]{2, 3, 4})), new RaftLogEntry(1L, (ReplicatedContent)new ReplicatedLockTokenRequest(MEMBER_ID, 2))}, 5L), new RaftMessages.AppendEntries.Response(MEMBER_ID, 1L, true, 2L, 3L), new RaftMessages.Vote.Request(MEMBER_ID, Long.MAX_VALUE, MEMBER_ID, Long.MIN_VALUE, 1L), new RaftMessages.Vote.Response(MEMBER_ID, 1L, true), new RaftMessages.PreVote.Request(MEMBER_ID, Long.MAX_VALUE, MEMBER_ID, Long.MIN_VALUE, 1L), new RaftMessages.PreVote.Response(MEMBER_ID, 1L, true), new RaftMessages.LogCompactionInfo(MEMBER_ID, Long.MAX_VALUE, Long.MIN_VALUE)};
    }

    @Before
    public void setupChannels() throws Exception {
        this.outbound = new EmbeddedChannel();
        this.inbound = new EmbeddedChannel();
        new RaftProtocolClientInstallerV2(new NettyPipelineBuilderFactory(VoidPipelineWrapperFactory.VOID_WRAPPER), Collections.emptyList(), (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out)).install((Channel)this.outbound);
        new RaftProtocolServerInstallerV2((ChannelInboundHandler)this.handler, new NettyPipelineBuilderFactory(VoidPipelineWrapperFactory.VOID_WRAPPER), Collections.emptyList(), (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out)).install((Channel)this.inbound);
    }

    @After
    public void cleanUp() {
        if (this.outbound != null) {
            this.outbound.close();
        }
        if (this.inbound != null) {
            this.inbound.close();
        }
        this.inbound = null;
        this.outbound = null;
    }

    @Test
    public void shouldEncodeDecodeRaftMessage() {
        Object o;
        ClusterId clusterId = new ClusterId(UUID.randomUUID());
        RaftMessages.ReceivedInstantClusterIdAwareMessage idAwareMessage = RaftMessages.ReceivedInstantClusterIdAwareMessage.of((Instant)Instant.now(), (ClusterId)clusterId, (RaftMessages.RaftMessage)this.raftMessage);
        this.outbound.writeOutbound(new Object[]{idAwareMessage});
        while ((o = this.outbound.readOutbound()) != null) {
            this.inbound.writeInbound(new Object[]{o});
        }
        RaftMessages.ReceivedInstantClusterIdAwareMessage<RaftMessages.RaftMessage> message = this.handler.getRaftMessage();
        Assert.assertEquals((Object)clusterId, (Object)message.clusterId());
        Assert.assertEquals((Object)this.raftMessage, (Object)message.message());
        Assert.assertNull((Object)this.inbound.readInbound());
    }

    class RaftMessageHandler
    extends SimpleChannelInboundHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<RaftMessages.RaftMessage>> {
        private RaftMessages.ReceivedInstantClusterIdAwareMessage<RaftMessages.RaftMessage> msg;

        RaftMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, RaftMessages.ReceivedInstantClusterIdAwareMessage<RaftMessages.RaftMessage> msg) {
            this.msg = msg;
        }

        RaftMessages.ReceivedInstantClusterIdAwareMessage<RaftMessages.RaftMessage> getRaftMessage() {
            return this.msg;
        }
    }
}

