/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.consensus.NewLeaderBarrier;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSet;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.LocalOperationId;
import org.neo4j.causalclustering.core.state.machines.dummy.DummyRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.TokenType;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.NetworkFlushableChannelNetty4;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.causalclustering.messaging.marshalling.CoreReplicatedContentMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

@RunWith(value=Parameterized.class)
public class CoreReplicatedContentMarshallingTest {
    @Parameterized.Parameter
    public ReplicatedContent replicatedContent;
    private ByteBuf buffer;

    @Parameterized.Parameters(name="{0}")
    public static ReplicatedContent[] data() {
        return new ReplicatedContent[]{new DummyRequest(new byte[]{1, 2, 3}), new ReplicatedTransaction(new byte[]{97, 3, 98}), new MemberIdSet((Set)new HashSet<MemberId>(){
            {
                this.add(new MemberId(UUID.randomUUID()));
            }
        }), new ReplicatedTokenRequest(TokenType.LABEL, "token", new byte[]{99, 111, 5}), new NewLeaderBarrier(), new ReplicatedLockTokenRequest(new MemberId(UUID.randomUUID()), 2), new DistributedOperation((ReplicatedContent)new DistributedOperation((ReplicatedContent)new ReplicatedTransaction(new byte[]{1, 2, 3, 4, 5, 6}), new GlobalSession(UUID.randomUUID(), new MemberId(UUID.randomUUID())), new LocalOperationId(1L, 2L)), new GlobalSession(UUID.randomUUID(), new MemberId(UUID.randomUUID())), new LocalOperationId(4L, 5L))};
    }

    @Before
    public void setUpBuffer() {
        this.buffer = Unpooled.buffer();
    }

    @After
    public void releaseBuffer() {
        if (this.buffer != null) {
            ReferenceCountUtil.release((Object)this.buffer);
        }
    }

    @Test
    public void shouldSerializeAndDeserialize() throws Exception {
        CoreReplicatedContentMarshal coreReplicatedContentSerializer = new CoreReplicatedContentMarshal();
        NetworkFlushableChannelNetty4 channel = new NetworkFlushableChannelNetty4(this.buffer);
        coreReplicatedContentSerializer.marshal((Object)this.replicatedContent, (WritableChannel)channel);
        NetworkReadableClosableChannelNetty4 readChannel = new NetworkReadableClosableChannelNetty4(this.buffer);
        ReplicatedContent result = (ReplicatedContent)coreReplicatedContentSerializer.unmarshal((ReadableChannel)readChannel);
        Assert.assertEquals((Object)this.replicatedContent, (Object)result);
    }
}

