/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.roles.AppendEntriesRequestBuilder;
import org.neo4j.causalclustering.core.consensus.roles.AppendEntriesResponseBuilder;
import org.neo4j.causalclustering.core.consensus.vote.VoteRequestBuilder;
import org.neo4j.causalclustering.core.consensus.vote.VoteResponseBuilder;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.v1.RaftMessageDecoder;
import org.neo4j.causalclustering.messaging.marshalling.v1.RaftMessageEncoder;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class RaftMessageEncodingDecodingTest {
    private ClusterId clusterId = new ClusterId(UUID.randomUUID());
    private static final ChannelMarshal<ReplicatedContent> marshal = new SafeChannelMarshal<ReplicatedContent>(){

        public void marshal(ReplicatedContent content, WritableChannel channel) throws IOException {
            if (!(content instanceof ReplicatedInteger)) {
                throw new IllegalArgumentException("Unknown content type " + content.getClass());
            }
            channel.put((byte)1);
            channel.putInt(((ReplicatedInteger)content).get());
        }

        public ReplicatedContent unmarshal0(ReadableChannel channel) throws IOException {
            ReplicatedInteger content;
            byte type = channel.get();
            switch (type) {
                case 1: {
                    content = ReplicatedInteger.valueOf(channel.getInt());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown content type 0x%x", type));
                }
            }
            return content;
        }
    };

    @Test
    public void shouldSerializeAppendRequestWithMultipleEntries() throws Exception {
        MemberId sender = new MemberId(UUID.randomUUID());
        RaftMessages.AppendEntries.Request request = new AppendEntriesRequestBuilder().from(sender).leaderCommit(2L).leaderTerm(4L).logEntry(new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2))).logEntry(new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(3))).logEntry(new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(4))).build();
        this.serializeReadBackAndVerifyMessage((RaftMessages.RaftMessage)request);
    }

    @Test
    public void shouldSerializeAppendRequestWithNoEntries() throws Exception {
        MemberId sender = new MemberId(UUID.randomUUID());
        RaftMessages.AppendEntries.Request request = new AppendEntriesRequestBuilder().from(sender).leaderCommit(2L).leaderTerm(4L).build();
        this.serializeReadBackAndVerifyMessage((RaftMessages.RaftMessage)request);
    }

    @Test
    public void shouldSerializeAppendResponse() throws Exception {
        MemberId sender = new MemberId(UUID.randomUUID());
        RaftMessages.AppendEntries.Response request = new AppendEntriesResponseBuilder().from(sender).success().matchIndex(12L).build();
        this.serializeReadBackAndVerifyMessage((RaftMessages.RaftMessage)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSerializeHeartbeats() throws Exception {
        Instant now = Instant.now();
        Clock clock = Clock.fixed(now, ZoneOffset.UTC);
        RaftMessageEncoder encoder = new RaftMessageEncoder(marshal);
        RaftMessageDecoder decoder = new RaftMessageDecoder(marshal, clock);
        ArrayList thingsRead = new ArrayList(1);
        MemberId sender = new MemberId(UUID.randomUUID());
        RaftMessages.ReceivedInstantClusterIdAwareMessage message = RaftMessages.ReceivedInstantClusterIdAwareMessage.of((Instant)now, (ClusterId)this.clusterId, (RaftMessages.RaftMessage)new RaftMessages.Heartbeat(sender, 1L, 2L, 3L));
        ChannelHandlerContext ctx = RaftMessageEncodingDecodingTest.setupContext();
        ByteBuf buffer = null;
        try {
            buffer = ctx.alloc().buffer();
            encoder.encode(ctx, (RaftMessages.ClusterIdAwareMessage)message, buffer);
            decoder.decode(null, buffer, thingsRead);
            Assert.assertEquals((long)1L, (long)thingsRead.size());
            Assert.assertEquals((Object)message, thingsRead.get(0));
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    @Test
    public void shouldSerializeVoteRequest() throws Exception {
        MemberId sender = new MemberId(UUID.randomUUID());
        RaftMessages.Vote.Request request = (RaftMessages.Vote.Request)new VoteRequestBuilder().candidate(sender).from(sender).lastLogIndex(2L).lastLogTerm(1L).term(3L).build();
        this.serializeReadBackAndVerifyMessage((RaftMessages.RaftMessage)request);
    }

    @Test
    public void shouldSerializeVoteResponse() throws Exception {
        MemberId sender = new MemberId(UUID.randomUUID());
        RaftMessages.Vote.Response request = (RaftMessages.Vote.Response)new VoteResponseBuilder().from(sender).grant().term(3L).build();
        this.serializeReadBackAndVerifyMessage((RaftMessages.RaftMessage)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeReadBackAndVerifyMessage(RaftMessages.RaftMessage message) throws Exception {
        Instant now = Instant.now();
        Clock clock = Clock.fixed(now, ZoneOffset.UTC);
        RaftMessageEncoder encoder = new RaftMessageEncoder(marshal);
        RaftMessageDecoder decoder = new RaftMessageDecoder(marshal, clock);
        ArrayList thingsRead = new ArrayList(1);
        RaftMessages.ReceivedInstantClusterIdAwareMessage decoratedMessage = RaftMessages.ReceivedInstantClusterIdAwareMessage.of((Instant)now, (ClusterId)this.clusterId, (RaftMessages.RaftMessage)message);
        ChannelHandlerContext ctx = RaftMessageEncodingDecodingTest.setupContext();
        ByteBuf buffer = null;
        try {
            buffer = ctx.alloc().buffer();
            encoder.encode(ctx, (RaftMessages.ClusterIdAwareMessage)decoratedMessage, buffer);
            decoder.decode(null, buffer, thingsRead);
            Assert.assertEquals((long)1L, (long)thingsRead.size());
            Assert.assertEquals((Object)decoratedMessage, thingsRead.get(0));
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    private static ChannelHandlerContext setupContext() {
        ChannelHandlerContext context = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)context.alloc()).thenReturn((Object)ByteBufAllocator.DEFAULT);
        return context;
    }
}

