/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.messaging.marshalling.ByteArrayByteBufAwareMarshal;

public class ByteArrayByteBufAwareMarshalTest {
    @Test
    public void shouldWriteToBufferInChunks() throws IOException {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6};
        byte[] readData = new byte[6];
        ByteArrayByteBufAwareMarshal byteArraySerializer = new ByteArrayByteBufAwareMarshal(data);
        ByteBuf buffer = Unpooled.buffer((int)5);
        Assert.assertTrue((boolean)byteArraySerializer.encode(buffer));
        Assert.assertEquals((long)6L, (long)buffer.readInt());
        Assert.assertEquals((long)1L, (long)buffer.readableBytes());
        buffer.readBytes(readData, 0, 1);
        buffer.release();
        buffer = Unpooled.buffer((int)6);
        Assert.assertFalse((boolean)byteArraySerializer.encode(buffer));
        buffer.readBytes(readData, 1, buffer.readableBytes());
        Assert.assertArrayEquals((byte[])data, (byte[])readData);
        Assert.assertEquals((long)0L, (long)buffer.readableBytes());
        buffer.release();
    }

    @Test
    public void shouldHaveSameLengthAsBytesEncoded() throws IOException {
        byte[] data = new byte[10];
        ByteArrayByteBufAwareMarshal byteArraySerializer = new ByteArrayByteBufAwareMarshal(data);
        ByteBuf buffer = Unpooled.buffer((int)100);
        byteArraySerializer.encode(buffer);
        Assert.assertEquals((long)buffer.readableBytes(), (long)byteArraySerializer.length());
    }
}

