/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.management;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.state.ClusterStateDirectory;
import org.neo4j.causalclustering.management.CausalClusteringBean;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.management.CausalClustering;

public class CausalClusteringBeanTest {
    private final FileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
    private final GraphDatabaseAPI db = (GraphDatabaseAPI)Mockito.mock(CoreGraphDatabase.class);
    private final File dataDir = new File("dataDir");
    private final ClusterStateDirectory clusterStateDirectory = ClusterStateDirectory.withoutInitializing((File)this.dataDir);
    private final RaftMachine raftMachine = (RaftMachine)Mockito.mock(RaftMachine.class);
    private CausalClustering ccBean;

    @Before
    public void setUp() {
        KernelData kernelData = new KernelData(this.fs, (PageCache)Mockito.mock(PageCache.class), new File("storeDir"), Config.defaults(), this.db);
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)this.clusterStateDirectory);
        dependencies.satisfyDependency((Object)this.raftMachine);
        Mockito.when((Object)this.db.getDependencyResolver()).thenReturn((Object)dependencies);
        ManagementData data = new ManagementData((ManagementBeanProvider)new CausalClusteringBean(), kernelData, ManagementSupport.load());
        this.ccBean = (CausalClustering)new CausalClusteringBean().createMBean(data);
    }

    @Test
    public void getCurrentRoleFromRaftMachine() {
        Mockito.when((Object)this.raftMachine.currentRole()).thenReturn((Object)Role.LEADER, (Object[])new Role[]{Role.FOLLOWER, Role.CANDIDATE});
        Assert.assertEquals((Object)"LEADER", (Object)this.ccBean.getRole());
        Assert.assertEquals((Object)"FOLLOWER", (Object)this.ccBean.getRole());
        Assert.assertEquals((Object)"CANDIDATE", (Object)this.ccBean.getRole());
    }

    @Test
    public void returnSumOfRaftLogDirectory() throws Exception {
        File raftLogDirectory = new File(this.clusterStateDirectory.get(), "raft-log");
        this.fs.mkdirs(raftLogDirectory);
        this.createFileOfSize(new File(raftLogDirectory, "raftLog1"), 5);
        this.createFileOfSize(new File(raftLogDirectory, "raftLog2"), 10);
        Assert.assertEquals((long)15L, (long)this.ccBean.getRaftLogSize());
    }

    @Test
    public void excludeRaftLogFromReplicatedStateSize() throws Exception {
        File stateDir = this.clusterStateDirectory.get();
        File raftLogDirectory = new File(stateDir, "raft-log");
        this.fs.mkdirs(raftLogDirectory);
        this.createFileOfSize(new File(raftLogDirectory, "raftLog1"), 5);
        File idAllocationDir = new File(stateDir, "id-allocation");
        this.fs.mkdirs(idAllocationDir);
        this.createFileOfSize(new File(idAllocationDir, "state"), 10);
        File lockTokenDir = new File(stateDir, "lock-token");
        this.fs.mkdirs(lockTokenDir);
        this.createFileOfSize(new File(lockTokenDir, "state"), 20);
        Assert.assertEquals((long)30L, (long)this.ccBean.getReplicatedStateSize());
    }

    private void createFileOfSize(File file, int size) throws IOException {
        try (StoreChannel storeChannel = this.fs.create(file);){
            byte[] bytes = new byte[size];
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            storeChannel.writeAll(buffer);
        }
    }
}

