/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.helper.StateAwareSuspendableLifeCycle;
import org.neo4j.causalclustering.helper.Suspendable;
import org.neo4j.causalclustering.helper.SuspendableLifecycleStateTestHelpers;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.AssertableLogProvider;

@RunWith(value=Parameterized.class)
public class SuspendableLifeCycleLifeStateChangeTest {
    @Parameterized.Parameter
    public SuspendableLifecycleStateTestHelpers.LifeCycleState fromState;
    @Parameterized.Parameter(value=1)
    public SuspendableLifecycleStateTestHelpers.SuspendedState fromSuspendedState;
    @Parameterized.Parameter(value=2)
    public SuspendableLifecycleStateTestHelpers.LifeCycleState toLifeCycleState;
    @Parameterized.Parameter(value=3)
    public SuspendableLifecycleStateTestHelpers.LifeCycleState shouldBeRunning;
    private StateAwareSuspendableLifeCycle lifeCycle;

    @Parameterized.Parameters(name="From {0} and {1} to {2} should end in {3}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SuspendableLifecycleStateTestHelpers.LifeCycleState lifeCycleState : SuspendableLifecycleStateTestHelpers.LifeCycleState.values()) {
            for (SuspendableLifecycleStateTestHelpers.SuspendedState suspendedState : SuspendableLifecycleStateTestHelpers.SuspendedState.values()) {
                for (SuspendableLifecycleStateTestHelpers.LifeCycleState toState : SuspendableLifeCycleLifeStateChangeTest.lifeCycleOperation()) {
                    params.add(new Object[]{lifeCycleState, suspendedState, toState, SuspendableLifeCycleLifeStateChangeTest.expectedResult(suspendedState, toState)});
                }
            }
        }
        return params;
    }

    private static SuspendableLifecycleStateTestHelpers.LifeCycleState[] lifeCycleOperation() {
        return new SuspendableLifecycleStateTestHelpers.LifeCycleState[]{SuspendableLifecycleStateTestHelpers.LifeCycleState.Start, SuspendableLifecycleStateTestHelpers.LifeCycleState.Stop};
    }

    @Before
    public void setUpServer() throws Throwable {
        this.lifeCycle = new StateAwareSuspendableLifeCycle(new AssertableLogProvider(false).getLog("log"));
        SuspendableLifecycleStateTestHelpers.setInitialState(this.lifeCycle, this.fromState);
        this.fromSuspendedState.set((Suspendable)this.lifeCycle);
    }

    @Test
    public void changeLifeState() throws Throwable {
        this.toLifeCycleState.set((Lifecycle)this.lifeCycle);
        Assert.assertEquals((Object)((Object)this.shouldBeRunning), (Object)((Object)this.lifeCycle.status));
    }

    private static SuspendableLifecycleStateTestHelpers.LifeCycleState expectedResult(SuspendableLifecycleStateTestHelpers.SuspendedState state, SuspendableLifecycleStateTestHelpers.LifeCycleState toLifeCycle) {
        if (state == SuspendableLifecycleStateTestHelpers.SuspendedState.Untouched || state == SuspendableLifecycleStateTestHelpers.SuspendedState.Enabled) {
            return toLifeCycle;
        }
        if (state == SuspendableLifecycleStateTestHelpers.SuspendedState.Disabled) {
            if (toLifeCycle == SuspendableLifecycleStateTestHelpers.LifeCycleState.Shutdown) {
                return toLifeCycle;
            }
            return SuspendableLifecycleStateTestHelpers.LifeCycleState.Stop;
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)state));
    }
}

