/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.causalclustering.helper.CountingThrowingSuspendableLifeCycle;
import org.neo4j.causalclustering.helper.SuspendableLifeCycle;
import org.neo4j.function.ThrowingConsumer;

public class SuspendableLifeCycleFailingTest {
    private CountingThrowingSuspendableLifeCycle lifeCycle;

    @Before
    public void setup() throws Throwable {
        this.lifeCycle = new CountingThrowingSuspendableLifeCycle();
        this.lifeCycle.init();
    }

    @Test
    public void canEnableIfStopFailed() throws Throwable {
        this.lifeCycle.start();
        this.lifeCycle.setFailMode();
        this.runFailing((ThrowingConsumer<SuspendableLifeCycle, Throwable>)((ThrowingConsumer)SuspendableLifeCycle::stop));
        this.lifeCycle.setSuccessMode();
        this.lifeCycle.enable();
        Assert.assertEquals((long)2L, (long)this.lifeCycle.starts);
    }

    @Test
    public void canEnableIfShutdownFailed() throws Throwable {
        this.lifeCycle.start();
        this.lifeCycle.setFailMode();
        this.runFailing((ThrowingConsumer<SuspendableLifeCycle, Throwable>)((ThrowingConsumer)SuspendableLifeCycle::shutdown));
        this.lifeCycle.setSuccessMode();
        this.lifeCycle.enable();
        Assert.assertEquals((long)2L, (long)this.lifeCycle.starts);
    }

    @Test
    public void canStartifDisableFailed() throws Throwable {
        this.lifeCycle.setFailMode();
        this.runFailing((ThrowingConsumer<SuspendableLifeCycle, Throwable>)((ThrowingConsumer)SuspendableLifeCycle::disable));
        this.lifeCycle.setSuccessMode();
        this.lifeCycle.start();
        Assert.assertEquals((long)1L, (long)this.lifeCycle.starts);
    }

    private void runFailing(ThrowingConsumer<SuspendableLifeCycle, Throwable> consumer) throws Throwable {
        try {
            consumer.accept((Object)this.lifeCycle);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

