/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloaderService;
import org.neo4j.causalclustering.core.state.snapshot.NoTimeout;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.kernel.impl.util.CountingJobScheduler;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;

public class CoreStateDownloaderServiceTest {
    private final AdvertisedSocketAddress someMemberAddress = new AdvertisedSocketAddress("localhost", 1234);
    private final CatchupAddressProvider catchupAddressProvider = CatchupAddressProvider.fromSingleAddress((AdvertisedSocketAddress)this.someMemberAddress);
    private CentralJobScheduler centralJobScheduler;
    private DatabaseHealth dbHealth = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);

    @Before
    public void create() {
        this.centralJobScheduler = new CentralJobScheduler();
        this.centralJobScheduler.init();
    }

    @After
    public void shutdown() {
        this.centralJobScheduler.shutdown();
    }

    @Test
    public void shouldRunPersistentDownloader() throws Exception {
        CoreStateDownloader coreStateDownloader = (CoreStateDownloader)Mockito.mock(CoreStateDownloader.class);
        Mockito.when((Object)coreStateDownloader.downloadSnapshot((CatchupAddressProvider)ArgumentMatchers.any())).thenReturn((Object)true);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        Log log = (Log)Mockito.mock(Log.class);
        CoreStateDownloaderService coreStateDownloaderService = new CoreStateDownloaderService((JobScheduler)this.centralJobScheduler, coreStateDownloader, applicationProcess, this.logProvider(log), (TimeoutStrategy.Timeout)new NoTimeout(), () -> this.dbHealth, new Monitors());
        coreStateDownloaderService.scheduleDownload(this.catchupAddressProvider);
        this.waitForApplierToResume(applicationProcess);
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
        ((CoreStateDownloader)Mockito.verify((Object)coreStateDownloader, (VerificationMode)VerificationModeFactory.times((int)1))).downloadSnapshot((CatchupAddressProvider)ArgumentMatchers.any());
    }

    @Test
    public void shouldOnlyScheduleOnePersistentDownloaderTaskAtTheTime() throws InterruptedException {
        AtomicInteger schedules = new AtomicInteger();
        CountingJobScheduler countingJobScheduler = new CountingJobScheduler(schedules, this.centralJobScheduler);
        Semaphore blockDownloader = new Semaphore(0);
        BlockingCoreStateDownloader coreStateDownloader = new BlockingCoreStateDownloader(blockDownloader);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        Log log = (Log)Mockito.mock(Log.class);
        CoreStateDownloaderService coreStateDownloaderService = new CoreStateDownloaderService((JobScheduler)countingJobScheduler, (CoreStateDownloader)coreStateDownloader, applicationProcess, this.logProvider(log), (TimeoutStrategy.Timeout)new NoTimeout(), () -> this.dbHealth, new Monitors());
        coreStateDownloaderService.scheduleDownload(this.catchupAddressProvider);
        Thread.sleep(50L);
        coreStateDownloaderService.scheduleDownload(this.catchupAddressProvider);
        coreStateDownloaderService.scheduleDownload(this.catchupAddressProvider);
        coreStateDownloaderService.scheduleDownload(this.catchupAddressProvider);
        Assert.assertEquals((long)1L, (long)schedules.get());
        blockDownloader.release();
    }

    private void waitForApplierToResume(CommandApplicationProcess applicationProcess) throws TimeoutException {
        Predicates.await(() -> {
            try {
                ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }, (long)20L, (TimeUnit)TimeUnit.SECONDS);
    }

    private LogProvider logProvider(final Log log) {
        return new LogProvider(){

            public Log getLog(Class loggingClass) {
                return log;
            }

            public Log getLog(String name) {
                return log;
            }
        };
    }

    static class BlockingCoreStateDownloader
    extends CoreStateDownloader {
        private final Semaphore semaphore;

        BlockingCoreStateDownloader(Semaphore semaphore) {
            super(null, null, null, null, (LogProvider)NullLogProvider.getInstance(), null, null, null, null);
            this.semaphore = semaphore;
        }

        boolean downloadSnapshot(CatchupAddressProvider addressProvider) {
            this.semaphore.acquireUninterruptibly();
            return true;
        }
    }
}

