/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.causalclustering.core.state.StateRecoveryManager;
import org.neo4j.causalclustering.core.state.storage.SafeStateMarshal;
import org.neo4j.causalclustering.core.state.storage.StateMarshal;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class StateRecoveryManagerTest {
    private final TestDirectory testDir = TestDirectory.testDirectory();
    private final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.testDir);
    private final int NUMBER_OF_RECORDS_PER_FILE = 100;
    private final int NUMBER_OF_BYTES_PER_RECORD = 10;

    @Before
    public void checkArgs() {
        Assert.assertEquals((long)0L, (long)0L);
    }

    @Test
    public void shouldFailIfBothFilesAreEmpty() throws Exception {
        EphemeralFileSystemAbstraction fsa = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        File fileA = this.fileA();
        fsa.create(fileA);
        File fileB = this.fileB();
        fsa.create(fileB);
        StateRecoveryManager manager = new StateRecoveryManager((FileSystemAbstraction)fsa, (StateMarshal)new LongMarshal());
        try {
            StateRecoveryManager.RecoveryStatus recoveryStatus = manager.recover(fileA, fileB);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnPreviouslyInactiveWhenOneFileFullAndOneEmpty() throws Exception {
        EphemeralFileSystemAbstraction fsa = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        File fileA = this.fileA();
        StoreChannel channel = fsa.create(fileA);
        this.fillUpAndForce(channel);
        File fileB = this.fileB();
        fsa.create(fileB);
        StateRecoveryManager manager = new StateRecoveryManager((FileSystemAbstraction)fsa, (StateMarshal)new LongMarshal());
        StateRecoveryManager.RecoveryStatus recoveryStatus = manager.recover(fileA, fileB);
        Assert.assertEquals((Object)fileB, (Object)recoveryStatus.activeFile());
    }

    @Test
    public void shouldReturnTheEmptyFileAsPreviouslyInactiveWhenActiveContainsCorruptEntry() throws Exception {
        EphemeralFileSystemAbstraction fsa = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        File fileA = this.fileA();
        StoreChannel channel = fsa.create(fileA);
        ByteBuffer buffer = this.writeLong(999L);
        channel.writeAll(buffer);
        channel.force(false);
        File fileB = this.fileB();
        channel = fsa.create(fileB);
        channel.close();
        StateRecoveryManager manager = new StateRecoveryManager((FileSystemAbstraction)fsa, (StateMarshal)new LongMarshal());
        StateRecoveryManager.RecoveryStatus recoveryStatus = manager.recover(fileA, fileB);
        Assert.assertEquals((Object)999L, (Object)recoveryStatus.recoveredState());
        Assert.assertEquals((Object)fileB, (Object)recoveryStatus.activeFile());
    }

    @Test
    public void shouldReturnTheFullFileAsPreviouslyInactiveWhenActiveContainsCorruptEntry() throws Exception {
        EphemeralFileSystemAbstraction fsa = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        File fileA = this.fileA();
        StoreChannel channel = fsa.create(fileA);
        ByteBuffer buffer = this.writeLong(42L);
        channel.writeAll(buffer);
        channel.force(false);
        buffer.clear();
        buffer.putLong(101L);
        buffer.flip();
        channel.writeAll(buffer);
        channel.force(false);
        File fileB = this.fileB();
        fsa.create(fileB);
        StateRecoveryManager manager = new StateRecoveryManager((FileSystemAbstraction)fsa, (StateMarshal)new LongMarshal());
        StateRecoveryManager.RecoveryStatus recoveryStatus = manager.recover(fileA, fileB);
        Assert.assertEquals((Object)fileB, (Object)recoveryStatus.activeFile());
    }

    @Test
    public void shouldRecoverFromPartiallyWrittenEntriesInBothFiles() throws Exception {
        EphemeralFileSystemAbstraction fsa = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        StateRecoveryManager manager = new StateRecoveryManager((FileSystemAbstraction)fsa, (StateMarshal)new LongMarshal());
        this.writeSomeLongsIn(fsa, this.fileA(), 3L, 4L);
        this.writeSomeLongsIn(fsa, this.fileB(), 5L, 6L);
        this.writeSomeGarbage(fsa, this.fileA());
        this.writeSomeGarbage(fsa, this.fileB());
        StateRecoveryManager.RecoveryStatus recovered = manager.recover(this.fileA(), this.fileB());
        Assert.assertEquals((Object)this.fileA(), (Object)recovered.activeFile());
        Assert.assertEquals((Object)6L, (Object)recovered.recoveredState());
    }

    private File fileA() {
        return new File(this.testDir.directory(), "file.A");
    }

    private File fileB() {
        return new File(this.testDir.directory(), "file.B");
    }

    private void writeSomeGarbage(EphemeralFileSystemAbstraction fsa, File file) throws IOException {
        StoreChannel channel = fsa.open(file, OpenMode.READ_WRITE);
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(9876);
        buffer.flip();
        channel.writeAll(buffer);
        channel.force(false);
        channel.close();
    }

    private void writeSomeLongsIn(EphemeralFileSystemAbstraction fsa, File file, long ... longs) throws IOException {
        StoreChannel channel = fsa.open(file, OpenMode.READ_WRITE);
        ByteBuffer buffer = ByteBuffer.allocate(longs.length * 8);
        for (long aLong : longs) {
            buffer.putLong(aLong);
        }
        buffer.flip();
        channel.writeAll(buffer);
        channel.force(false);
        channel.close();
    }

    private void fillUpAndForce(StoreChannel channel) throws IOException {
        for (int i = 0; i < 100; ++i) {
            ByteBuffer buffer = this.writeLong(i);
            channel.writeAll(buffer);
            channel.force(false);
        }
    }

    private ByteBuffer writeLong(long logIndex) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(logIndex);
        buffer.flip();
        return buffer;
    }

    private static class LongMarshal
    extends SafeStateMarshal<Long> {
        private LongMarshal() {
        }

        public Long startState() {
            return 0L;
        }

        public long ordinal(Long aLong) {
            return aLong;
        }

        public void marshal(Long aLong, WritableChannel channel) throws IOException {
            channel.putLong(aLong.longValue());
        }

        protected Long unmarshal0(ReadableChannel channel) throws IOException {
            return channel.getLong();
        }
    }
}

