/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.term;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.monitoring.RaftTermMonitor;
import org.neo4j.causalclustering.core.consensus.term.MonitoredTermStateStorage;
import org.neo4j.causalclustering.core.consensus.term.TermState;
import org.neo4j.causalclustering.core.state.storage.InMemoryStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.kernel.monitoring.Monitors;

public class MonitoredTermStateStorageTest {
    @Test
    public void shouldMonitorTerm() throws Exception {
        Monitors monitors = new Monitors();
        StubRaftTermMonitor raftTermMonitor = new StubRaftTermMonitor();
        monitors.addMonitorListener((Object)raftTermMonitor, new String[0]);
        TermState state = new TermState();
        MonitoredTermStateStorage monitoredTermStateStorage = new MonitoredTermStateStorage((StateStorage)new InMemoryStateStorage((Object)new TermState()), monitors);
        state.update(7L);
        monitoredTermStateStorage.persistStoreData(state);
        Assert.assertEquals((long)7L, (long)raftTermMonitor.term());
    }

    private static class StubRaftTermMonitor
    implements RaftTermMonitor {
        private long term;

        private StubRaftTermMonitor() {
        }

        public long term() {
            return this.term;
        }

        public void term(long term) {
            this.term = term;
        }
    }
}

