/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.schedule;

import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.schedule.FixedTimeout;
import org.neo4j.causalclustering.core.consensus.schedule.Timeout;
import org.neo4j.causalclustering.core.consensus.schedule.TimeoutHandler;
import org.neo4j.causalclustering.core.consensus.schedule.Timer;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.util.concurrent.BinaryLatch;

public class TimerTest {
    @Rule
    public LifeRule lifeRule = new LifeRule(true);

    @Test
    public void shouldHandleConcurrentResetAndInvocationOfHandler() {
        CentralJobScheduler scheduler = (CentralJobScheduler)this.lifeRule.add((Lifecycle)new CentralJobScheduler());
        JobScheduler.Group group = new JobScheduler.Group("test");
        BinaryLatch invoked = new BinaryLatch();
        BinaryLatch done = new BinaryLatch();
        TimeoutHandler handler = timer -> {
            invoked.release();
            done.await();
        };
        Timer timer2 = new Timer(() -> "test", (JobScheduler)scheduler, (Log)NullLog.getInstance(), group, handler);
        timer2.set((Timeout)new FixedTimeout(0L, TimeUnit.SECONDS));
        invoked.await();
        timer2.reset();
        done.release();
    }
}

