/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.consensus.MessageUtils;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.TestMessageBuilders;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftStateBuilder;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLogProvider;

@RunWith(value=Parameterized.class)
public class PreVoteRequestTest {
    @Parameterized.Parameter
    public Role role;
    private MemberId myself = RaftTestMember.member(0);
    private MemberId member1 = RaftTestMember.member(1);
    private MemberId member2 = RaftTestMember.member(2);

    @Parameterized.Parameters(name="{0}")
    public static Collection data() {
        return Arrays.asList(Role.values());
    }

    @Test
    public void shouldDenyForCandidateInLaterTermWhenPreVoteNotActive() throws Exception {
        RaftState state = this.newState();
        long candidateTerm = state.term() + 1L;
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.preVoteRequest().from(this.member1).term(candidateTerm).lastLogIndex(0L).lastLogTerm(-1L).build(), (ReadableRaftState)state, this.log());
        Assert.assertFalse((boolean)((RaftMessages.PreVote.Response)MessageUtils.messageFor(outcome, this.member1)).voteGranted());
    }

    @Test
    public void shouldDenyForCandidateInPreviousTerm() throws Exception {
        RaftState state = this.newState();
        long candidateTerm = state.term() - 1L;
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.preVoteRequest().from(this.member1).term(candidateTerm).lastLogIndex(0L).lastLogTerm(-1L).build(), (ReadableRaftState)state, this.log());
        Assert.assertFalse((boolean)((RaftMessages.PreVote.Response)MessageUtils.messageFor(outcome, this.member1)).voteGranted());
        Assert.assertEquals((Object)this.role, (Object)outcome.getRole());
    }

    @Test
    public void shouldStayInCurrentRoleOnRequestFromCurrentTerm() throws Exception {
        RaftState state = this.newState();
        long candidateTerm = state.term();
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.preVoteRequest().from(this.member1).term(candidateTerm).lastLogIndex(0L).lastLogTerm(-1L).build(), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)this.role, (Object)outcome.getRole());
    }

    @Test
    public void shouldMoveToFollowerIfRequestIsFromLaterTerm() throws Exception {
        RaftState state = this.newState();
        long candidateTerm = state.term() + 1L;
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.preVoteRequest().from(this.member1).term(candidateTerm).lastLogIndex(0L).lastLogTerm(-1L).build(), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)Role.FOLLOWER, (Object)outcome.getRole());
    }

    @Test
    public void shouldUpdateTermIfRequestIsFromLaterTerm() throws Exception {
        RaftState state = this.newState();
        long candidateTerm = state.term() + 1L;
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.preVoteRequest().from(this.member1).term(candidateTerm).lastLogIndex(0L).lastLogTerm(-1L).build(), (ReadableRaftState)state, this.log());
        Assert.assertEquals((long)candidateTerm, (long)outcome.getTerm());
    }

    public RaftState newState() throws IOException {
        return RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).build();
    }

    private Log log() {
        return NullLogProvider.getInstance().getLog(this.getClass());
    }
}

