/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.MessageUtils;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.ReplicatedString;
import org.neo4j.causalclustering.core.consensus.TestMessageBuilders;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.membership.RaftTestGroup;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.Candidate;
import org.neo4j.causalclustering.core.consensus.roles.Follower;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftStateBuilder;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class FollowerTest {
    private MemberId myself = RaftTestMember.member(0);
    private MemberId member1 = RaftTestMember.member(1);
    private MemberId member2 = RaftTestMember.member(2);
    private MemberId member3 = RaftTestMember.member(3);
    private MemberId member4 = RaftTestMember.member(4);

    @Test
    public void shouldInstigateAnElectionAfterTimeout() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)RaftMessages.Type.VOTE_REQUEST, (Object)MessageUtils.messageFor(outcome, this.member1).type());
        Assert.assertEquals((Object)RaftMessages.Type.VOTE_REQUEST, (Object)MessageUtils.messageFor(outcome, this.member2).type());
    }

    @Test
    public void shouldBecomeCandidateOnReceivingElectionTimeoutMessage() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)Role.CANDIDATE, (Object)outcome.getRole());
    }

    @Test
    public void shouldNotInstigateElectionOnElectionTimeoutIfRefusingToBeLeaderAndPreVoteNotSupported() throws Throwable {
        RaftState state = RaftStateBuilder.raftState().setRefusesToBeLeader(true).supportsPreVoting(false).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome.getOutgoingMessages(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldIgnoreAnElectionTimeoutIfRefusingToBeLeaderAndPreVoteNotSupported() throws Throwable {
        RaftState state = RaftStateBuilder.raftState().setRefusesToBeLeader(true).supportsPreVoting(false).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)new Outcome(Role.FOLLOWER, (ReadableRaftState)state), (Object)outcome);
    }

    @Test
    public void shouldSetPreElectionOnTimeoutIfSupportedAndIAmVoterAndIRefuseToLead() throws Throwable {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).votingMembers(this.myself, this.member1, this.member2).setRefusesToBeLeader(true).supportsPreVoting(true).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        Assert.assertTrue((boolean)outcome.isPreElection());
    }

    @Test
    public void shouldNotSetPreElectionOnTimeoutIfSupportedAndIAmNotVoterAndIRefuseToLead() throws Throwable {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).votingMembers(this.member1, this.member2, this.member3).setRefusesToBeLeader(true).supportsPreVoting(true).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        Assert.assertFalse((boolean)outcome.isPreElection());
    }

    @Test
    public void shouldNotSolicitPreVotesOnTimeoutEvenIfSupportedIfRefuseToLead() throws Throwable {
        RaftState state = RaftStateBuilder.raftState().setRefusesToBeLeader(true).supportsPreVoting(true).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome.getOutgoingMessages(), (Matcher)Matchers.empty());
    }

    @Test
    public void followerReceivingHeartbeatIndicatingClusterIsAheadShouldElicitAppendResponse() throws Exception {
        int term = 1;
        int followerAppendIndex = 9;
        InMemoryRaftLog entryLog = new InMemoryRaftLog();
        entryLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(0))});
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).term(term).build();
        Follower follower = new Follower();
        this.appendSomeEntriesToLog(state, follower, followerAppendIndex - 1, term, 1);
        RaftMessages.AppendEntries.Request heartbeat = TestMessageBuilders.appendEntriesRequest().from(this.member1).leaderTerm(term).prevLogIndex(followerAppendIndex + 2).prevLogTerm(term).build();
        Outcome outcome = follower.handle((RaftMessages.RaftMessage)heartbeat, (ReadableRaftState)state, this.log());
        Assert.assertEquals((long)1L, (long)outcome.getOutgoingMessages().size());
        RaftMessages.RaftMessage outgoing = ((RaftMessages.Directed)outcome.getOutgoingMessages().iterator().next()).message();
        Assert.assertEquals((Object)RaftMessages.Type.APPEND_ENTRIES_RESPONSE, (Object)outgoing.type());
        RaftMessages.AppendEntries.Response response = (RaftMessages.AppendEntries.Response)outgoing;
        Assert.assertFalse((boolean)response.success());
    }

    @Test
    public void shouldTruncateIfTermDoesNotMatch() throws Exception {
        InMemoryRaftLog entryLog = new InMemoryRaftLog();
        entryLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(0))});
        int term = 1;
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).entryLog((RaftLog)entryLog).term(term).build();
        Follower follower = new Follower();
        state.update(follower.handle((RaftMessages.RaftMessage)new RaftMessages.AppendEntries.Request(this.member1, 1L, 0L, 0L, new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ContentGenerator.content())}, 0L), (ReadableRaftState)state, this.log()));
        RaftLogEntry[] entries = new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)new ReplicatedString("commit this!"))};
        Outcome outcome = follower.handle((RaftMessages.RaftMessage)new RaftMessages.AppendEntries.Request(this.member1, 1L, 0L, 0L, entries, 0L), (ReadableRaftState)state, this.log());
        state.update(outcome);
        Assert.assertEquals((long)1L, (long)state.entryLog().appendIndex());
        Assert.assertEquals((long)1L, (long)state.entryLog().readEntryTerm(1L));
    }

    @Test
    public void followerLearningAboutHigherCommitCausesValuesTobeAppliedToItsLog() throws Exception {
        InMemoryRaftLog entryLog = new InMemoryRaftLog();
        entryLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(0))});
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).entryLog((RaftLog)entryLog).build();
        Follower follower = new Follower();
        this.appendSomeEntriesToLog(state, follower, 3, 0, 1);
        Outcome outcome = follower.handle((RaftMessages.RaftMessage)new RaftMessages.AppendEntries.Request(this.myself, 0L, 3L, 0L, new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ContentGenerator.content())}, 4L), (ReadableRaftState)state, this.log());
        state.update(outcome);
        Assert.assertEquals((long)4L, (long)state.commitIndex());
    }

    @Test
    public void shouldUpdateCommitIndexIfNecessary() throws Exception {
        InMemoryRaftLog entryLog = new InMemoryRaftLog();
        entryLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(0))});
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).entryLog((RaftLog)entryLog).build();
        Follower follower = new Follower();
        int localAppendIndex = 3;
        int localCommitIndex = localAppendIndex - 1;
        int term = 0;
        this.appendSomeEntriesToLog(state, follower, localAppendIndex, term, 1);
        Outcome raftTestMemberOutcome = new Outcome(Role.FOLLOWER, (ReadableRaftState)state);
        raftTestMemberOutcome.setCommitIndex((long)localCommitIndex);
        state.update(raftTestMemberOutcome);
        Assert.assertEquals((long)localAppendIndex, (long)state.entryLog().appendIndex());
        Assert.assertEquals((long)localCommitIndex, (long)state.commitIndex());
        Outcome outcome = follower.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().leaderTerm(term).prevLogIndex(3L).prevLogTerm(term).leaderCommit(localCommitIndex + 4).build(), (ReadableRaftState)state, this.log());
        state.update(outcome);
        Assert.assertEquals((long)3L, (long)state.commitIndex());
    }

    @Test
    public void shouldNotRenewElectionTimeoutOnReceiptOfHeartbeatInLowerTerm() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).term(2L).build();
        Follower follower = new Follower();
        Outcome outcome = follower.handle((RaftMessages.RaftMessage)new RaftMessages.Heartbeat(this.myself, 1L, 1L, 1L), (ReadableRaftState)state, this.log());
        Assert.assertFalse((boolean)outcome.electionTimeoutRenewed());
    }

    @Test
    public void shouldAcknowledgeHeartbeats() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).term(2L).build();
        Follower follower = new Follower();
        Outcome outcome = follower.handle((RaftMessages.RaftMessage)new RaftMessages.Heartbeat(state.leader(), 2L, 2L, 2L), (ReadableRaftState)state, this.log());
        Collection outgoingMessages = outcome.getOutgoingMessages();
        Assert.assertTrue((boolean)outgoingMessages.contains(new RaftMessages.Directed(state.leader(), (RaftMessages.RaftMessage)new RaftMessages.HeartbeatResponse(this.myself))));
    }

    @Test
    public void shouldRespondPositivelyToPreVoteRequestsIfWouldVoteForCandidate() throws Exception {
        RaftState raftState = this.preElectionActive();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, 0L, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome, this.member1);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).voteGranted(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldRespondPositivelyToPreVoteRequestsEvenIfAlreadyVotedInRealElection() throws Exception {
        RaftState raftState = this.preElectionActive();
        raftState.update(new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Vote.Request(this.member1, 0L, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log()));
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member2, 0L, this.member2, 0L, 0L), (ReadableRaftState)raftState, this.log());
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome, this.member2);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).voteGranted(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldRespondNegativelyToPreVoteRequestsIfNotInPreVoteMyself() throws Exception {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).setPreElection(false).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, 0L, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome, this.member1);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).voteGranted(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldRespondNegativelyToPreVoteRequestsIfWouldNotVoteForCandidate() throws Exception {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).term(1L).setPreElection(true).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, 0L, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome, this.member1);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).voteGranted(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldRespondPositivelyToPreVoteRequestsToMultipleMembersIfWouldVoteForAny() throws Exception {
        RaftState raftState = this.preElectionActive();
        Outcome outcome1 = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, 0L, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        raftState.update(outcome1);
        Outcome outcome2 = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member2, 0L, this.member2, 0L, 0L), (ReadableRaftState)raftState, this.log());
        raftState.update(outcome2);
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome2, this.member2);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).voteGranted(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldUseTermFromPreVoteRequestIfHigherThanOwn() throws Exception {
        RaftState raftState = this.preElectionActive();
        long newTerm = raftState.term() + 1L;
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, newTerm, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome, this.member1);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).term(), (Matcher)Matchers.equalTo((Object)newTerm));
    }

    @Test
    public void shouldUpdateOutcomeWithTermFromPreVoteRequestOfLaterTermIfInPreVoteState() throws Throwable {
        RaftState raftState = this.preElectionActive();
        long newTerm = raftState.term() + 1L;
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, newTerm, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((long)newTerm, (long)outcome.getTerm());
    }

    @Test
    public void shouldUpdateOutcomeWithTermFromPreVoteRequestOfLaterTermIfNotInPreVoteState() throws Throwable {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).setPreElection(false).build();
        long newTerm = raftState.term() + 1L;
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, newTerm, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((long)newTerm, (long)outcome.getTerm());
    }

    @Test
    public void shouldInstigatePreElectionIfSupportedAndNotActiveAndReceiveTimeout() throws Throwable {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).supportsPreVoting(true).setPreElection(false).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)RaftMessages.Type.PRE_VOTE_REQUEST, (Object)MessageUtils.messageFor(outcome, this.member1).type());
        Assert.assertEquals((Object)RaftMessages.Type.PRE_VOTE_REQUEST, (Object)MessageUtils.messageFor(outcome, this.member2).type());
    }

    @Test
    public void shouldSetPreElectionActiveWhenReceiveTimeout() throws Throwable {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).supportsPreVoting(true).setPreElection(false).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)true, (Object)outcome.isPreElection());
    }

    @Test
    public void shouldInstigatePreElectionIfSupportedAndActiveAndReceiveTimeout() throws Throwable {
        RaftState raftState = this.preElectionActive();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)RaftMessages.Type.PRE_VOTE_REQUEST, (Object)MessageUtils.messageFor(outcome, this.member1).type());
        Assert.assertEquals((Object)RaftMessages.Type.PRE_VOTE_REQUEST, (Object)MessageUtils.messageFor(outcome, this.member2).type());
        Assert.assertEquals((Object)RaftMessages.Type.PRE_VOTE_REQUEST, (Object)MessageUtils.messageFor(outcome, this.member3).type());
    }

    @Test
    public void shouldKeepPreElectionActiveWhenReceiveTimeout() throws Throwable {
        RaftState raftState = this.preElectionActive();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)true, (Object)outcome.isPreElection());
    }

    @Test
    public void shouldAbortPreElectionIfReceivePreVoteResponseFromNewerTerm() throws Throwable {
        RaftState raftState = this.preElectionActive();
        long newTerm = raftState.term() + 1L;
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, newTerm, false), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((long)newTerm, (long)outcome.getTerm());
        Assert.assertEquals((Object)false, (Object)outcome.isPreElection());
    }

    @Test
    public void shouldIgnoreVotesFromEarlierTerms() throws Throwable {
        RaftState raftState = this.preElectionActive();
        long oldTerm = raftState.term() - 1L;
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, oldTerm, true), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)new Outcome(Role.FOLLOWER, (ReadableRaftState)raftState), (Object)outcome);
    }

    @Test
    public void shouldIgnoreVotesDeclining() throws Throwable {
        RaftState raftState = this.preElectionActive();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, raftState.term(), false), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)new Outcome(Role.FOLLOWER, (ReadableRaftState)raftState), (Object)outcome);
    }

    @Test
    public void shouldAddVoteFromADifferentMember() throws Throwable {
        RaftState raftState = this.preElectionActive();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, raftState.term(), true), (ReadableRaftState)raftState, this.log());
        Assert.assertThat((Object)outcome.getPreVotesForMe(), (Matcher)Matchers.contains((Object[])new MemberId[]{this.member1}));
    }

    @Test
    public void shouldNotAddVoteFromMyself() throws Throwable {
        RaftState raftState = this.preElectionActive();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.myself, raftState.term(), true), (ReadableRaftState)raftState, this.log());
        Assert.assertThat((Object)outcome.getPreVotesForMe(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new MemberId[]{this.member1})));
    }

    @Test
    public void shouldNotStartElectionIfHaveNotReachedQuorum() throws Throwable {
        RaftState raftState = this.preElectionActive();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, raftState.term(), true), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)Role.FOLLOWER, (Object)outcome.getRole());
    }

    @Test
    public void shouldTransitionToCandidateIfHaveReachedQuorum() throws Throwable {
        RaftState raftState = this.preElectionActive();
        Outcome outcome1 = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, raftState.term(), true), (ReadableRaftState)raftState, this.log());
        raftState.update(outcome1);
        Outcome outcome2 = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member2, raftState.term(), true), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)Role.CANDIDATE, (Object)outcome2.getRole());
    }

    @Test
    public void shouldInstigateElectionIfHaveReachedQuorum() throws Throwable {
        RaftState raftState = this.preElectionActive();
        Outcome outcome1 = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, raftState.term(), true), (ReadableRaftState)raftState, this.log());
        raftState.update(outcome1);
        Outcome outcome2 = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member2, raftState.term(), true), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)RaftMessages.Type.VOTE_REQUEST, (Object)MessageUtils.messageFor(outcome2, this.member1).type());
        Assert.assertEquals((Object)RaftMessages.Type.VOTE_REQUEST, (Object)MessageUtils.messageFor(outcome2, this.member2).type());
        Assert.assertEquals((Object)RaftMessages.Type.VOTE_REQUEST, (Object)MessageUtils.messageFor(outcome2, this.member3).type());
    }

    @Test
    public void shouldIgnorePreVoteResponsesIfPreVoteInactive() throws Throwable {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).setPreElection(false).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, raftState.term(), true), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)new Outcome(Role.FOLLOWER, (ReadableRaftState)raftState), (Object)outcome);
    }

    @Test
    public void shouldIgnorePreVoteRequestsIfPreVoteUnsupported() throws Throwable {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(false).setPreElection(false).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, raftState.term(), this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)new Outcome(Role.FOLLOWER, (ReadableRaftState)raftState), (Object)outcome);
    }

    @Test
    public void shouldIgnorePreVoteResponsesIfPreVoteUnsupported() throws Throwable {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(false).setPreElection(false).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, raftState.term(), true), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)new Outcome(Role.FOLLOWER, (ReadableRaftState)raftState), (Object)outcome);
    }

    @Test
    public void shouldIgnorePreVoteResponseWhenPreElectionFalseRefuseToBeLeader() throws Throwable {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).setPreElection(false).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).setRefusesToBeLeader(true).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, raftState.term(), true), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)new Outcome(Role.FOLLOWER, (ReadableRaftState)raftState), (Object)outcome);
    }

    @Test
    public void shouldIgnorePreVoteResponseWhenPreElectionTrueAndRefuseLeader() throws Throwable {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).setPreElection(true).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).setRefusesToBeLeader(true).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, raftState.term(), true), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)new Outcome(Role.FOLLOWER, (ReadableRaftState)raftState), (Object)outcome);
    }

    @Test
    public void shouldNotInstigateElectionOnPreVoteResponseWhenPreElectionTrueAndRefuseLeader() throws Throwable {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).setPreElection(true).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).setRefusesToBeLeader(true).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, raftState.term(), true), (ReadableRaftState)raftState, this.log());
        Assert.assertThat((Object)outcome.getOutgoingMessages(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldDeclinePreVoteRequestsIfPreElectionNotActiveAndRefusesToLead() throws Throwable {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).setPreElection(false).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).setRefusesToBeLeader(true).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, raftState.term(), this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)false, (Object)((RaftMessages.PreVote.Response)MessageUtils.messageFor(outcome, this.member1)).voteGranted());
    }

    @Test
    public void shouldApprovePreVoteRequestIfPreElectionActiveAndRefusesToLead() throws Throwable {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).setPreElection(true).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).setRefusesToBeLeader(true).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, raftState.term(), this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((Object)true, (Object)((RaftMessages.PreVote.Response)MessageUtils.messageFor(outcome, this.member1)).voteGranted());
    }

    @Test
    public void shouldSetPreElectionOnElectionTimeout() throws Exception {
        RaftState state = this.preElectionSupported();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome);
        Assert.assertThat((Object)outcome.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome.isPreElection(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldSendPreVoteRequestsOnElectionTimeout() throws Exception {
        RaftState state = this.preElectionSupported();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome);
        Assert.assertThat((Object)MessageUtils.messageFor(outcome, this.member1).type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_REQUEST));
        Assert.assertThat((Object)MessageUtils.messageFor(outcome, this.member2).type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_REQUEST));
    }

    @Test
    public void shouldProceedToRealElectionIfReceiveQuorumOfPositivePreVoteResponses() throws Exception {
        RaftState state = this.preElectionSupported();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome2.getRole(), (Matcher)Matchers.equalTo((Object)Role.CANDIDATE));
        Assert.assertThat((Object)outcome2.isPreElection(), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)outcome2.getPreVotesForMe(), (Matcher)Matchers.contains((Object[])new MemberId[]{this.member1}));
    }

    @Test
    public void shouldIgnorePreVotePositiveResponsesFromOlderTerm() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).term(1L).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome2.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome2.isPreElection(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)outcome2.getPreVotesForMe(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldIgnorePositivePreVoteResponsesIfNotInPreVotingStage() throws Exception {
        RaftState state = this.preElectionSupported();
        Follower underTest = new Follower();
        Outcome outcome = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome.isPreElection(), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)outcome.getPreVotesForMe(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldNotMoveToRealElectionWithoutPreVoteQuorum() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2, this.member3, this.member4})).build();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome2.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome2.isPreElection(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)outcome2.getPreVotesForMe(), (Matcher)Matchers.contains((Object[])new MemberId[]{this.member1}));
    }

    @Test
    public void shouldMoveToRealElectionWithPreVoteQuorumOf5() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2, this.member3, this.member4})).build();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        state.update(outcome2);
        Outcome outcome3 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member2, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome3.getRole(), (Matcher)Matchers.equalTo((Object)Role.CANDIDATE));
        Assert.assertThat((Object)outcome3.isPreElection(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotCountPreVotesVotesFromSameMemberTwice() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2, this.member3, this.member4})).build();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        state.update(outcome2);
        Outcome outcome3 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome3.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome3.isPreElection(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldResetPreVotesWhenMovingBackToFollower() throws Exception {
        RaftState state = this.preElectionSupported();
        Outcome outcome1 = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)Role.CANDIDATE, (Matcher)Matchers.equalTo((Object)outcome2.getRole()));
        Assert.assertThat((Object)outcome2.getPreVotesForMe(), (Matcher)Matchers.contains((Object[])new MemberId[]{this.member1}));
        Outcome outcome3 = new Candidate().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome3.getPreVotesForMe(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldSendRealVoteRequestsIfReceivePositivePreVoteResponses() throws Exception {
        RaftState state = this.preElectionSupported();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)MessageUtils.messageFor(outcome2, this.member1).type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.VOTE_REQUEST));
        Assert.assertThat((Object)MessageUtils.messageFor(outcome2, this.member2).type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.VOTE_REQUEST));
    }

    @Test
    public void shouldNotProceedToRealElectionIfReceiveNegativePreVoteResponses() throws Exception {
        RaftState state = this.preElectionSupported();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, false), (ReadableRaftState)state, this.log());
        state.update(outcome2);
        Outcome outcome3 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member2, 0L, false), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome3.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome3.isPreElection(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)outcome3.getPreVotesForMe(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldNotSendRealVoteRequestsIfReceiveNegativePreVoteResponses() throws Exception {
        RaftState state = this.preElectionSupported();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, false), (ReadableRaftState)state, this.log());
        state.update(outcome2);
        Outcome outcome3 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member2, 0L, false), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome2.getOutgoingMessages(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)outcome3.getOutgoingMessages(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldResetPreVoteIfReceiveHeartbeatFromLeader() throws Exception {
        RaftState state = this.preElectionSupported();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Heartbeat(this.member1, 0L, 0L, 0L), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome2.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome2.isPreElection(), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)outcome2.getPreVotesForMe(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldResetPreVoteIfReceiveAppendEntriesRequestFromLeader() throws Exception {
        RaftState state = this.preElectionSupported();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().leaderTerm(state.term()).prevLogTerm(state.term()).prevLogIndex(0L).build(), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome2.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome2.isPreElection(), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)outcome2.getPreVotesForMe(), (Matcher)Matchers.empty());
    }

    private RaftState preElectionActive() throws IOException {
        return RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).setPreElection(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2, this.member3})).build();
    }

    private RaftState preElectionSupported() throws IOException {
        return RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
    }

    private void appendSomeEntriesToLog(RaftState raft, Follower follower, int numberOfEntriesToAppend, int term, int firstIndex) throws IOException {
        for (int i = 0; i < numberOfEntriesToAppend; ++i) {
            int prevLogIndex = firstIndex + i - 1;
            raft.update(follower.handle((RaftMessages.RaftMessage)new RaftMessages.AppendEntries.Request(this.myself, (long)term, (long)prevLogIndex, (long)term, new RaftLogEntry[]{new RaftLogEntry((long)term, (ReplicatedContent)ContentGenerator.content())}, -1L), (ReadableRaftState)raft, this.log()));
        }
    }

    private Log log() {
        return NullLog.getInstance();
    }

    private static class ContentGenerator {
        private static int count;

        private ContentGenerator() {
        }

        public static ReplicatedString content() {
            return new ReplicatedString(String.format("content#%d", count++));
        }
    }
}

