/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.membership.MembershipWaiter;
import org.neo4j.causalclustering.core.consensus.state.ExposedRaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftStateBuilder;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;

public class MembershipWaiterTest {
    private DatabaseHealth dbHealth = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);

    @Before
    public void mocking() {
        Mockito.when((Object)this.dbHealth.isHealthy()).thenReturn((Object)true);
    }

    @Test
    public void shouldReturnImmediatelyIfMemberAndCaughtUp() throws Exception {
        OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();
        MembershipWaiter waiter = new MembershipWaiter(RaftTestMember.member(0), (JobScheduler)jobScheduler, () -> this.dbHealth, 500L, (LogProvider)NullLogProvider.getInstance(), new Monitors());
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(0))});
        ExposedRaftState raftState = RaftStateBuilder.raftState().votingMembers(RaftTestMember.member(0)).leaderCommit(0L).entryLog((RaftLog)raftLog).commitIndex(0L).build().copy();
        RaftMachine raft = (RaftMachine)Mockito.mock(RaftMachine.class);
        Mockito.when((Object)raft.state()).thenReturn((Object)raftState);
        CompletableFuture future = waiter.waitUntilCaughtUpMember(raft);
        jobScheduler.runJob();
        jobScheduler.runJob();
        future.get(0L, TimeUnit.NANOSECONDS);
    }

    @Test
    public void shouldWaitUntilLeaderCommitIsAvailable() throws Exception {
        OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();
        MembershipWaiter waiter = new MembershipWaiter(RaftTestMember.member(0), (JobScheduler)jobScheduler, () -> this.dbHealth, 500L, (LogProvider)NullLogProvider.getInstance(), new Monitors());
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(0))});
        ExposedRaftState raftState = RaftStateBuilder.raftState().votingMembers(RaftTestMember.member(0)).leaderCommit(0L).entryLog((RaftLog)raftLog).commitIndex(0L).build().copy();
        RaftMachine raft = (RaftMachine)Mockito.mock(RaftMachine.class);
        Mockito.when((Object)raft.state()).thenReturn((Object)raftState);
        CompletableFuture future = waiter.waitUntilCaughtUpMember(raft);
        jobScheduler.runJob();
        future.get(1L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldTimeoutIfCaughtUpButNotMember() throws Exception {
        OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();
        MembershipWaiter waiter = new MembershipWaiter(RaftTestMember.member(0), (JobScheduler)jobScheduler, () -> this.dbHealth, 1L, (LogProvider)NullLogProvider.getInstance(), new Monitors());
        ExposedRaftState raftState = RaftStateBuilder.raftState().votingMembers(RaftTestMember.member(1)).leaderCommit(0L).build().copy();
        RaftMachine raft = (RaftMachine)Mockito.mock(RaftMachine.class);
        Mockito.when((Object)raft.state()).thenReturn((Object)raftState);
        CompletableFuture future = waiter.waitUntilCaughtUpMember(raft);
        jobScheduler.runJob();
        jobScheduler.runJob();
        try {
            future.get(10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should have timed out.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test
    public void shouldTimeoutIfMemberButNotCaughtUp() throws Exception {
        OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();
        MembershipWaiter waiter = new MembershipWaiter(RaftTestMember.member(0), (JobScheduler)jobScheduler, () -> this.dbHealth, 1L, (LogProvider)NullLogProvider.getInstance(), new Monitors());
        ExposedRaftState raftState = RaftStateBuilder.raftState().votingMembers(RaftTestMember.member(0), RaftTestMember.member(1)).leaderCommit(0L).build().copy();
        RaftMachine raft = (RaftMachine)Mockito.mock(RaftMachine.class);
        Mockito.when((Object)raft.state()).thenReturn((Object)raftState);
        CompletableFuture future = waiter.waitUntilCaughtUpMember(raft);
        jobScheduler.runJob();
        jobScheduler.runJob();
        try {
            future.get(10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should have timed out.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test
    public void shouldTimeoutIfLeaderCommitIsNeverKnown() throws Exception {
        OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();
        MembershipWaiter waiter = new MembershipWaiter(RaftTestMember.member(0), (JobScheduler)jobScheduler, () -> this.dbHealth, 1L, (LogProvider)NullLogProvider.getInstance(), new Monitors());
        ExposedRaftState raftState = RaftStateBuilder.raftState().leaderCommit(-1L).build().copy();
        RaftMachine raft = (RaftMachine)Mockito.mock(RaftMachine.class);
        Mockito.when((Object)raft.state()).thenReturn((Object)raftState);
        CompletableFuture future = waiter.waitUntilCaughtUpMember(raft);
        jobScheduler.runJob();
        try {
            future.get(10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should have timed out.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }
}

