/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.membership.CatchupGoal;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerState;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class CatchupGoalTest {
    @Test
    public void goalAchievedWhenCatchupRoundDurationLessThanTarget() {
        FakeClock clock = Clocks.fakeClock();
        long electionTimeout = 15L;
        StubLog log = new StubLog();
        log.setAppendIndex(10L);
        CatchupGoal goal = new CatchupGoal((ReadableRaftLog)log, (Clock)clock, electionTimeout);
        log.setAppendIndex(20L);
        clock.forward(10L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)goal.achieved(new FollowerState()));
        log.setAppendIndex(30L);
        clock.forward(10L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)goal.achieved(new FollowerState().onSuccessResponse(10L)));
        log.setAppendIndex(40L);
        clock.forward(10L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)goal.achieved(new FollowerState().onSuccessResponse(30L)));
    }

    private class StubLog
    implements ReadableRaftLog {
        private long appendIndex;

        private StubLog() {
        }

        private void setAppendIndex(long index) {
            this.appendIndex = index;
        }

        public long appendIndex() {
            return this.appendIndex;
        }

        public long prevIndex() {
            return 0L;
        }

        public long readEntryTerm(long logIndex) {
            return 0L;
        }

        public RaftLogCursor getEntryCursor(long fromIndex) {
            return RaftLogCursor.empty();
        }
    }
}

