/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.consensus.log.segmented.Reader;
import org.neo4j.causalclustering.core.consensus.log.segmented.ReaderPool;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class ReaderPoolTest {
    private final File base = new File("base");
    private final FileNames fileNames = new FileNames(this.base);
    private final EphemeralFileSystemAbstraction fsa = (EphemeralFileSystemAbstraction)Mockito.spy((Object)new EphemeralFileSystemAbstraction());
    private final FakeClock clock = Clocks.fakeClock();
    private ReaderPool pool = new ReaderPool(2, (LogProvider)NullLogProvider.getInstance(), this.fileNames, (FileSystemAbstraction)this.fsa, (Clock)this.clock);

    @Before
    public void before() {
        this.fsa.mkdirs(this.base);
    }

    @After
    public void tearDown() throws Exception {
        this.fsa.close();
    }

    @Test
    public void shouldReacquireReaderFromPool() throws Exception {
        Reader reader = this.pool.acquire(0L, 0L);
        this.pool.release(reader);
        Reader newReader = this.pool.acquire(0L, 0L);
        ((EphemeralFileSystemAbstraction)Mockito.verify((Object)this.fsa, (VerificationMode)Mockito.times((int)1))).open((File)ArgumentMatchers.any(), (OpenMode)ArgumentMatchers.any());
        Assert.assertThat((Object)reader, (Matcher)Matchers.is((Object)newReader));
    }

    @Test
    public void shouldPruneOldReaders() throws Exception {
        Reader readerA = (Reader)Mockito.spy((Object)this.pool.acquire(0L, 0L));
        Reader readerB = (Reader)Mockito.spy((Object)this.pool.acquire(0L, 0L));
        this.pool.release(readerA);
        this.clock.forward(2L, TimeUnit.MINUTES);
        this.pool.release(readerB);
        this.clock.forward(1L, TimeUnit.MINUTES);
        this.pool.prune(2L, TimeUnit.MINUTES);
        ((Reader)Mockito.verify((Object)readerA)).close();
        ((Reader)Mockito.verify((Object)readerB, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void shouldNotReturnPrunedReaders() throws Exception {
        Reader readerA = this.pool.acquire(0L, 0L);
        Reader readerB = this.pool.acquire(0L, 0L);
        this.pool.release(readerA);
        this.pool.release(readerB);
        this.clock.forward(2L, TimeUnit.MINUTES);
        this.pool.prune(1L, TimeUnit.MINUTES);
        Reader readerC = this.pool.acquire(0L, 0L);
        Reader readerD = this.pool.acquire(0L, 0L);
        Assert.assertThat((Object)Iterators.asSet((Object[])new Reader[]{readerC, readerD}), (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Object[])new Reader[]{readerA, readerB})));
    }

    @Test
    public void shouldDisposeSuperfluousReaders() throws Exception {
        Reader readerA = (Reader)Mockito.spy((Object)this.pool.acquire(0L, 0L));
        Reader readerB = (Reader)Mockito.spy((Object)this.pool.acquire(0L, 0L));
        Reader readerC = (Reader)Mockito.spy((Object)this.pool.acquire(0L, 0L));
        Reader readerD = (Reader)Mockito.spy((Object)this.pool.acquire(0L, 0L));
        this.pool.release(readerA);
        this.pool.release(readerB);
        this.pool.release(readerC);
        this.pool.release(readerD);
        ((Reader)Mockito.verify((Object)readerA)).close();
        ((Reader)Mockito.verify((Object)readerB)).close();
        ((Reader)Mockito.verify((Object)readerC, (VerificationMode)Mockito.never())).close();
        ((Reader)Mockito.verify((Object)readerD, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void shouldDisposeAllReleasedReaders() throws Exception {
        Reader readerA = (Reader)Mockito.spy((Object)this.pool.acquire(0L, 0L));
        Reader readerB = (Reader)Mockito.spy((Object)this.pool.acquire(0L, 0L));
        Reader readerC = (Reader)Mockito.spy((Object)this.pool.acquire(0L, 0L));
        this.pool.release(readerA);
        this.pool.release(readerB);
        this.pool.release(readerC);
        this.pool.close();
        ((Reader)Mockito.verify((Object)readerA)).close();
        ((Reader)Mockito.verify((Object)readerB)).close();
        ((Reader)Mockito.verify((Object)readerC)).close();
    }

    @Test
    public void shouldPruneReadersOfVersion() throws Exception {
        this.pool = new ReaderPool(8, (LogProvider)NullLogProvider.getInstance(), this.fileNames, (FileSystemAbstraction)this.fsa, (Clock)this.clock);
        Reader readerA = (Reader)Mockito.spy((Object)this.pool.acquire(0L, 0L));
        Reader readerB = (Reader)Mockito.spy((Object)this.pool.acquire(1L, 0L));
        Reader readerC = (Reader)Mockito.spy((Object)this.pool.acquire(1L, 0L));
        Reader readerD = (Reader)Mockito.spy((Object)this.pool.acquire(2L, 0L));
        this.pool.release(readerA);
        this.pool.release(readerB);
        this.pool.release(readerC);
        this.pool.release(readerD);
        this.pool.prune(1L);
        ((Reader)Mockito.verify((Object)readerA, (VerificationMode)Mockito.never())).close();
        ((Reader)Mockito.verify((Object)readerB)).close();
        ((Reader)Mockito.verify((Object)readerC)).close();
        ((Reader)Mockito.verify((Object)readerD, (VerificationMode)Mockito.never())).close();
        this.pool.prune(0L);
        ((Reader)Mockito.verify((Object)readerA)).close();
        ((Reader)Mockito.verify((Object)readerD, (VerificationMode)Mockito.never())).close();
        this.pool.prune(2L);
        ((Reader)Mockito.verify((Object)readerD)).close();
    }
}

