/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMachineBuilder;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.TestMessageBuilders;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.RaftLogHelper;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.membership.RaftTestGroup;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.identity.RaftTestMemberSetBuilder;

@RunWith(value=MockitoJUnitRunner.class)
public class RaftMachineLogTest {
    @Mock
    RaftMachineBuilder.CommitListener commitListener;
    private MemberId myself = RaftTestMember.member(0);
    private ReplicatedContent content = ReplicatedInteger.valueOf(1);
    private RaftLog testEntryLog;
    private RaftMachine raft;

    @Before
    public void before() throws Exception {
        this.testEntryLog = new InMemoryRaftLog();
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(this.myself))});
        this.raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).raftLog(this.testEntryLog).commitListener(this.commitListener).build();
    }

    @Test
    public void shouldPersistAtSpecifiedLogIndex() throws Exception {
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().leaderTerm(0L).prevLogIndex(0L).prevLogTerm(0L).logEntry(new RaftLogEntry(0L, this.content)).build());
        Assert.assertEquals((long)1L, (long)this.testEntryLog.appendIndex());
        Assert.assertEquals((Object)this.content, (Object)RaftLogHelper.readLogEntry((ReadableRaftLog)this.testEntryLog, 1L).content());
    }

    @Test
    public void shouldOnlyPersistSameLogEntryOnce() throws Exception {
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().leaderTerm(0L).prevLogIndex(0L).prevLogTerm(0L).logEntry(new RaftLogEntry(0L, this.content)).build());
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().leaderTerm(0L).prevLogIndex(0L).prevLogTerm(0L).logEntry(new RaftLogEntry(0L, this.content)).build());
        Assert.assertEquals((long)1L, (long)this.testEntryLog.appendIndex());
        Assert.assertEquals((Object)this.content, (Object)RaftLogHelper.readLogEntry((ReadableRaftLog)this.testEntryLog, 1L).content());
    }

    @Test
    public void shouldRemoveLaterEntryFromLogConflictingWithNewEntry() throws Exception {
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(4))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(7))});
        ReplicatedInteger newData = ReplicatedInteger.valueOf(11);
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().leaderTerm(2L).prevLogIndex(2L).prevLogTerm(1L).logEntry(new RaftLogEntry(2L, (ReplicatedContent)newData)).build());
        Assert.assertEquals((long)3L, (long)this.testEntryLog.appendIndex());
        Assert.assertEquals((Object)newData, (Object)RaftLogHelper.readLogEntry((ReadableRaftLog)this.testEntryLog, 3L).content());
    }

    @Test
    public void shouldNotTouchTheLogIfWeDoMatchEverywhere() throws Exception {
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        ReplicatedInteger newData = ReplicatedInteger.valueOf(99);
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().leaderTerm(8L).prevLogIndex(5L).prevLogTerm(2L).logEntry(new RaftLogEntry(2L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(3L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(3L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(3L, (ReplicatedContent)newData)).build());
        Assert.assertEquals((long)11L, (long)this.testEntryLog.appendIndex());
        Assert.assertEquals((long)3L, (long)this.testEntryLog.readEntryTerm(11L));
    }

    @Test
    public void shouldNotTouchTheLogIfWeDoNotMatchAnywhere() throws Exception {
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        ReplicatedInteger newData = ReplicatedInteger.valueOf(99);
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().leaderTerm(8L).prevLogIndex(6L).prevLogTerm(5L).logEntry(new RaftLogEntry(5L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(5L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(6L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(6L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(6L, (ReplicatedContent)newData)).build());
        Assert.assertEquals((long)11L, (long)this.testEntryLog.appendIndex());
        Assert.assertEquals((long)3L, (long)this.testEntryLog.readEntryTerm(11L));
    }

    @Test
    public void shouldTruncateOnFirstMismatchAndThenAppendOtherEntries() throws Exception {
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        ReplicatedInteger newData = ReplicatedInteger.valueOf(99);
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().leaderTerm(8L).prevLogIndex(0L).prevLogTerm(0L).logEntry(new RaftLogEntry(1L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(1L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(1L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(4L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(4L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(5L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(5L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(6L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(6L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(6L, (ReplicatedContent)newData)).build());
        Assert.assertEquals((long)10L, (long)this.testEntryLog.appendIndex());
        Assert.assertEquals((long)1L, (long)this.testEntryLog.readEntryTerm(1L));
        Assert.assertEquals((long)1L, (long)this.testEntryLog.readEntryTerm(2L));
        Assert.assertEquals((long)1L, (long)this.testEntryLog.readEntryTerm(3L));
        Assert.assertEquals((long)4L, (long)this.testEntryLog.readEntryTerm(4L));
        Assert.assertEquals((long)4L, (long)this.testEntryLog.readEntryTerm(5L));
        Assert.assertEquals((long)5L, (long)this.testEntryLog.readEntryTerm(6L));
        Assert.assertEquals((long)5L, (long)this.testEntryLog.readEntryTerm(7L));
        Assert.assertEquals((long)6L, (long)this.testEntryLog.readEntryTerm(8L));
        Assert.assertEquals((long)6L, (long)this.testEntryLog.readEntryTerm(9L));
        Assert.assertEquals((long)6L, (long)this.testEntryLog.readEntryTerm(10L));
    }

    @Test
    public void shouldNotTruncateLogIfHistoryDoesNotMatch() throws Exception {
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        ReplicatedInteger newData = ReplicatedInteger.valueOf(99);
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().leaderTerm(8L).prevLogIndex(4L).prevLogTerm(4L).logEntry(new RaftLogEntry(4L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(5L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(5L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(6L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(6L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(6L, (ReplicatedContent)newData)).build());
        Assert.assertEquals((long)11L, (long)this.testEntryLog.appendIndex());
    }

    @Test
    public void shouldTruncateLogIfFirstEntryMatchesAndSecondEntryMismatchesOnTerm() throws Exception {
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        this.testEntryLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        ReplicatedInteger newData = ReplicatedInteger.valueOf(99);
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().leaderTerm(8L).prevLogIndex(2L).prevLogTerm(1L).logEntry(new RaftLogEntry(1L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(4L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(4L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(5L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(5L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(6L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(6L, (ReplicatedContent)newData)).logEntry(new RaftLogEntry(6L, (ReplicatedContent)newData)).build());
        Assert.assertEquals((long)10L, (long)this.testEntryLog.appendIndex());
        Assert.assertEquals((long)1L, (long)this.testEntryLog.readEntryTerm(1L));
        Assert.assertEquals((long)1L, (long)this.testEntryLog.readEntryTerm(2L));
        Assert.assertEquals((long)1L, (long)this.testEntryLog.readEntryTerm(3L));
        Assert.assertEquals((long)4L, (long)this.testEntryLog.readEntryTerm(4L));
        Assert.assertEquals((long)4L, (long)this.testEntryLog.readEntryTerm(5L));
        Assert.assertEquals((long)5L, (long)this.testEntryLog.readEntryTerm(6L));
        Assert.assertEquals((long)5L, (long)this.testEntryLog.readEntryTerm(7L));
        Assert.assertEquals((long)6L, (long)this.testEntryLog.readEntryTerm(8L));
        Assert.assertEquals((long)6L, (long)this.testEntryLog.readEntryTerm(9L));
        Assert.assertEquals((long)6L, (long)this.testEntryLog.readEntryTerm(10L));
    }
}

