/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.CausalClusterConfigurationValidator;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.impl.enterprise.configuration.EnterpriseEditionSettings;

@RunWith(value=Parameterized.class)
public class CausalClusterConfigurationValidatorTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Parameterized.Parameter
    public EnterpriseEditionSettings.Mode mode;

    @Parameterized.Parameters(name="{0}")
    public static List<EnterpriseEditionSettings.Mode> recordFormats() {
        return Arrays.asList(EnterpriseEditionSettings.Mode.CORE, EnterpriseEditionSettings.Mode.READ_REPLICA);
    }

    @Test
    public void validateOnlyIfModeIsCoreOrReplica() {
        Config config = Config.fromSettings((Map)MapUtil.stringMap((String[])new String[]{this.mode.name(), EnterpriseEditionSettings.Mode.SINGLE.name(), CausalClusteringSettings.initial_discovery_members.name(), ""})).withValidator((ConfigurationValidator)new CausalClusterConfigurationValidator()).build();
        Optional value = config.getRaw(CausalClusteringSettings.initial_discovery_members.name());
        Assert.assertTrue((boolean)value.isPresent());
        Assert.assertEquals((Object)"", value.get());
    }

    @Test
    public void validateSuccess() {
        Config config = Config.fromSettings((Map)MapUtil.stringMap((String[])new String[]{this.mode.name(), this.mode.name(), CausalClusteringSettings.initial_discovery_members.name(), "localhost:99,remotehost:2", new BoltConnector((String)"bolt").enabled.name(), "true"})).withValidator((ConfigurationValidator)new CausalClusterConfigurationValidator()).build();
        Assert.assertEquals(Arrays.asList(new AdvertisedSocketAddress("localhost", 99), new AdvertisedSocketAddress("remotehost", 2)), (Object)config.get(CausalClusteringSettings.initial_discovery_members));
    }

    @Test
    public void missingInitialMembers() {
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Missing mandatory non-empty value for 'causal_clustering.initial_discovery_members'");
        Config.builder().withSetting(EnterpriseEditionSettings.mode, this.mode.name()).withValidator((ConfigurationValidator)new CausalClusterConfigurationValidator()).build();
    }

    @Test
    public void missingBoltConnector() {
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("A Bolt connector must be configured to run a cluster");
        Config.fromSettings((Map)MapUtil.stringMap((String[])new String[]{EnterpriseEditionSettings.mode.name(), this.mode.name(), CausalClusteringSettings.initial_discovery_members.name(), "localhost:99,remotehost:2"})).withValidator((ConfigurationValidator)new CausalClusterConfigurationValidator()).build();
    }
}

