/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpWriter;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.Commands;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.InvalidLogEntryHandler;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.test.rule.NeoStoreDataSourceRule;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class TransactionLogCatchUpWriterTest {
    @Rule
    public final TestDirectory dir = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public NeoStoreDataSourceRule dsRule = new NeoStoreDataSourceRule();
    @Parameterized.Parameter
    public boolean partOfStoreCopy;
    private PageCache pageCache;
    private FileSystemAbstraction fs;
    private File storeDir;

    @Parameterized.Parameters
    public static List<Boolean> partOfStoreCopy() {
        return Arrays.asList(Boolean.TRUE, Boolean.FALSE);
    }

    @Before
    public void setup() {
        this.storeDir = this.dir.directory("graph.db");
        this.fs = this.fsRule.get();
        this.pageCache = this.pageCacheRule.getPageCache(this.fs);
    }

    @Test
    public void shouldCreateTransactionLogWithCheckpoint() throws Exception {
        this.createTransactionLogWithCheckpoint(Config.defaults(), true);
    }

    @Test
    public void createTransactionLogWithCheckpointInCustomLocation() throws IOException {
        this.createTransactionLogWithCheckpoint(Config.defaults((Setting)GraphDatabaseSettings.logical_logs_location, (String)"custom-tx-logs"), false);
    }

    @Test
    public void pullRotatesWhenThresholdCrossedAndExplicitlySet() throws IOException {
        Config config = Config.defaults();
        config.augment(GraphDatabaseSettings.logical_log_rotation_threshold, "1m");
        org.neo4j.kernel.impl.store.StoreId storeId = this.simulateStoreCopy();
        long fromTx = 0L;
        TransactionLogCatchUpWriter subject = new TransactionLogCatchUpWriter(this.storeDir, this.fs, this.pageCache, config, (LogProvider)NullLogProvider.getInstance(), fromTx, this.partOfStoreCopy, false, true);
        IntStream.range(0, (int)ByteUnit.mebiBytes((long)1L)).mapToObj(TransactionLogCatchUpWriterTest::tx).map(tx -> new TxPullResponse(this.toCasualStoreId(storeId), tx)).forEach(arg_0 -> ((TransactionLogCatchUpWriter)subject).onTxReceived(arg_0));
        subject.close();
        LogFilesBuilder logFilesBuilder = LogFilesBuilder.activeFilesBuilder((File)this.storeDir, (FileSystemAbstraction)this.fs, (PageCache)this.pageCache);
        LogFiles logFiles = logFilesBuilder.build();
        Assert.assertNotEquals((long)logFiles.getLowestLogVersion(), (long)logFiles.getHighestLogVersion());
    }

    @Test
    public void pullDoesntRotateWhenThresholdCrossedAndExplicitlyOff() throws IOException {
        Config config = Config.defaults();
        config.augment(GraphDatabaseSettings.logical_log_rotation_threshold, "1m");
        org.neo4j.kernel.impl.store.StoreId storeId = this.simulateStoreCopy();
        long fromTx = 0L;
        TransactionLogCatchUpWriter subject = new TransactionLogCatchUpWriter(this.storeDir, this.fs, this.pageCache, config, (LogProvider)NullLogProvider.getInstance(), fromTx, this.partOfStoreCopy, false, false);
        IntStream.range(0, (int)ByteUnit.mebiBytes((long)1L)).mapToObj(TransactionLogCatchUpWriterTest::tx).map(tx -> new TxPullResponse(this.toCasualStoreId(storeId), tx)).forEach(arg_0 -> ((TransactionLogCatchUpWriter)subject).onTxReceived(arg_0));
        subject.close();
        LogFilesBuilder logFilesBuilder = LogFilesBuilder.activeFilesBuilder((File)this.storeDir, (FileSystemAbstraction)this.fs, (PageCache)this.pageCache);
        LogFiles logFiles = logFilesBuilder.build();
        Assert.assertEquals((long)logFiles.getLowestLogVersion(), (long)logFiles.getHighestLogVersion());
    }

    private void createTransactionLogWithCheckpoint(Config config, boolean logsInStoreDir) throws IOException {
        org.neo4j.kernel.impl.store.StoreId storeId = this.simulateStoreCopy();
        int fromTxId = 37;
        int endTxId = fromTxId + 5;
        TransactionLogCatchUpWriter catchUpWriter = new TransactionLogCatchUpWriter(this.storeDir, this.fs, this.pageCache, config, (LogProvider)NullLogProvider.getInstance(), (long)fromTxId, this.partOfStoreCopy, logsInStoreDir, true);
        for (int i = fromTxId; i <= endTxId; ++i) {
            catchUpWriter.onTxReceived(new TxPullResponse(this.toCasualStoreId(storeId), TransactionLogCatchUpWriterTest.tx(i)));
        }
        catchUpWriter.close();
        LogFilesBuilder logFilesBuilder = LogFilesBuilder.activeFilesBuilder((File)this.storeDir, (FileSystemAbstraction)this.fs, (PageCache)this.pageCache);
        if (!logsInStoreDir) {
            logFilesBuilder.withConfig(config);
        }
        LogFiles logFiles = logFilesBuilder.build();
        this.verifyTransactionsInLog(logFiles, fromTxId, endTxId);
        if (this.partOfStoreCopy) {
            this.verifyCheckpointInLog(logFiles);
        }
    }

    private void verifyCheckpointInLog(LogFiles logFiles) {
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader((CommandReaderFactory)new RecordStorageCommandReaderFactory(), InvalidLogEntryHandler.STRICT);
        LogTailScanner logTailScanner = new LogTailScanner(logFiles, (LogEntryReader)logEntryReader, new Monitors());
        LogTailScanner.LogTailInformation tailInformation = logTailScanner.getTailInformation();
        Assert.assertNotNull((Object)tailInformation.lastCheckPoint);
        Assert.assertTrue((boolean)tailInformation.commitsAfterLastCheckpoint());
    }

    private void verifyTransactionsInLog(LogFiles logFiles, long fromTxId, long endTxId) throws IOException {
        long expectedTxId = fromTxId;
        PhysicalLogVersionedStoreChannel versionedStoreChannel = logFiles.openForVersion(0L);
        try (ReadAheadLogChannel channel = new ReadAheadLogChannel((LogVersionedStoreChannel)versionedStoreChannel, LogVersionBridge.NO_MORE_CHANNELS, 1024);
             PhysicalTransactionCursor txCursor = new PhysicalTransactionCursor((ReadableClosablePositionAwareChannel)channel, (LogEntryReader)new VersionAwareLogEntryReader());){
            while (txCursor.next()) {
                CommittedTransactionRepresentation tx = txCursor.get();
                long txId = tx.getCommitEntry().getTxId();
                MatcherAssert.assertThat((Object)expectedTxId, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(endTxId)));
                Assert.assertEquals((long)expectedTxId, (long)txId);
                ++expectedTxId;
            }
        }
    }

    private org.neo4j.kernel.impl.store.StoreId simulateStoreCopy() throws IOException {
        org.neo4j.kernel.impl.store.StoreId storeId;
        NeoStoreDataSource ds = this.dsRule.getDataSource(this.storeDir, this.fs, this.pageCache);
        try (Lifespan ignored = new Lifespan(new Lifecycle[]{ds});){
            storeId = ds.getStoreId();
        }
        LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.storeDir, (FileSystemAbstraction)this.fsRule.get()).build();
        logFiles.accept((file, version) -> file.delete());
        return storeId;
    }

    private StoreId toCasualStoreId(org.neo4j.kernel.impl.store.StoreId storeId) {
        return new StoreId(storeId.getCreationTime(), storeId.getRandomId(), storeId.getUpgradeTime(), storeId.getUpgradeId());
    }

    private static CommittedTransactionRepresentation tx(int id) {
        return new CommittedTransactionRepresentation(new LogEntryStart(id, id, (long)id, (long)(id - 1), new byte[0], LogPosition.UNSPECIFIED), Commands.transactionRepresentation((Command[])new Command[]{Commands.createNode((long)0L, (long[])new long[0])}), new LogEntryCommit((long)id, (long)id));
    }
}

