/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStream;
import org.neo4j.causalclustering.catchup.storecopy.StreamToDiskProvider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class StreamToDiskTest {
    private static final byte[] DATA = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.directory).around((TestRule)this.pageCacheRule);

    @Test
    public void shouldLetPageCacheHandleRecordStoresAndNativeLabelScanStoreFiles() throws Exception {
        Monitors monitors = new Monitors();
        StreamToDiskProvider writerProvider = new StreamToDiskProvider(this.directory.absolutePath(), (FileSystemAbstraction)this.fs, monitors);
        for (StoreType type : StoreType.values()) {
            if (!type.isRecordStore()) continue;
            String fileName = type.getStoreFile().fileName(StoreFileType.STORE);
            this.writeAndVerify(writerProvider, fileName);
        }
        this.writeAndVerify(writerProvider, "neostore.labelscanstore.db");
    }

    private void writeAndVerify(StreamToDiskProvider writerProvider, String fileName) throws Exception {
        try (StoreFileStream acquire = writerProvider.acquire(fileName, 16);){
            acquire.write(DATA);
        }
        File expectedFile = new File(this.directory.absolutePath(), fileName);
        Assert.assertTrue((String)"Streamed file created.", (boolean)this.fs.fileExists(expectedFile));
        Assert.assertEquals((long)DATA.length, (long)this.fs.getFileSize(expectedFile));
    }
}

