/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpClientException;
import org.neo4j.causalclustering.catchup.CatchUpResponseCallback;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.storecopy.GetIndexFilesRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreFileRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdRequest;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyRequest;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClient;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreamProvider;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.catchup.storecopy.TerminationCondition;
import org.neo4j.causalclustering.helper.ConstantTimeTimeoutStrategy;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.messaging.CatchUpRequest;
import org.neo4j.com.storecopy.StoreCopyClientMonitor;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.rule.SuppressOutput;

public class StoreCopyClientTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private final CatchUpClient catchUpClient = (CatchUpClient)Mockito.mock(CatchUpClient.class);
    private StoreCopyClient subject;
    private final LogProvider logProvider = FormattedLogProvider.withDefaultLogLevel((Level)Level.DEBUG).toOutputStream((OutputStream)System.out);
    private final Monitors monitors = new Monitors();
    private final AdvertisedSocketAddress expectedAdvertisedAddress = new AdvertisedSocketAddress("host", 1234);
    private final CatchupAddressProvider catchupAddressProvider = CatchupAddressProvider.fromSingleAddress((AdvertisedSocketAddress)this.expectedAdvertisedAddress);
    private final StoreId expectedStoreId = new StoreId(1L, 2L, 3L, 4L);
    private final StoreFileStreamProvider expectedStoreFileStream = (StoreFileStreamProvider)Mockito.mock(StoreFileStreamProvider.class);
    private File[] serverFiles = new File[]{new File("fileA.txt"), new File("fileB.bmp")};
    private File targetLocation = new File("targetLocation");
    private LongSet indexIds = LongSets.immutable.of(13L);
    private ConstantTimeTimeoutStrategy backOffStrategy;

    @Before
    public void setup() {
        this.backOffStrategy = new ConstantTimeTimeoutStrategy(1L, TimeUnit.MILLISECONDS);
        this.subject = new StoreCopyClient(this.catchUpClient, this.monitors, this.logProvider, (TimeoutStrategy)this.backOffStrategy);
    }

    @Test
    public void clientRequestsAllFilesListedInListingResponse() throws StoreCopyFailedException, CatchUpClientException {
        PrepareStoreCopyResponse prepareStoreCopyResponse = PrepareStoreCopyResponse.success((File[])this.serverFiles, (LongSet)this.indexIds, (long)-123L);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(PrepareStoreCopyRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)prepareStoreCopyResponse);
        StoreCopyFinishedResponse success = new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.SUCCESS);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(GetStoreFileRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)success);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(GetIndexFilesRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)success);
        this.subject.copyStoreFiles(this.catchupAddressProvider, this.expectedStoreId, this.expectedStoreFileStream, this.continueIndefinitely(), this.targetLocation);
        List<String> filteredRequests = this.filenamesFromIndividualFileRequests(this.getRequests());
        List expectedFiles = Stream.of(this.serverFiles).map(File::getName).collect(Collectors.toList());
        Assert.assertThat(expectedFiles, (Matcher)Matchers.containsInAnyOrder((Object[])filteredRequests.toArray()));
    }

    private Supplier<TerminationCondition> continueIndefinitely() {
        return () -> TerminationCondition.CONTINUE_INDEFINITELY;
    }

    @Test
    public void storeIdCanBeRetrieved() throws StoreIdDownloadFailedException, CatchUpClientException {
        StoreId remoteStoreId = new StoreId(6L, 3L, 2L, 6L);
        AdvertisedSocketAddress remoteAddress = new AdvertisedSocketAddress("host", 1234);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.eq((Object)remoteAddress), (CatchUpRequest)ArgumentMatchers.any(GetStoreIdRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)remoteStoreId);
        StoreId actualStoreId = this.subject.fetchStoreId(remoteAddress);
        Assert.assertEquals((Object)remoteStoreId, (Object)actualStoreId);
    }

    @Test
    public void shouldNotAwaitOnSuccess() throws CatchUpClientException, StoreCopyFailedException {
        TimeoutStrategy.Timeout mockedTimeout = (TimeoutStrategy.Timeout)Mockito.mock(TimeoutStrategy.Timeout.class);
        TimeoutStrategy backoffStrategy = (TimeoutStrategy)Mockito.mock(TimeoutStrategy.class);
        Mockito.when((Object)backoffStrategy.newTimeout()).thenReturn((Object)mockedTimeout);
        this.subject = new StoreCopyClient(this.catchUpClient, this.monitors, this.logProvider, backoffStrategy);
        PrepareStoreCopyResponse prepareStoreCopyResponse = PrepareStoreCopyResponse.success((File[])this.serverFiles, (LongSet)this.indexIds, (long)-123L);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(PrepareStoreCopyRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)prepareStoreCopyResponse);
        StoreCopyFinishedResponse success = new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.SUCCESS);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(GetStoreFileRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)success);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(GetIndexFilesRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)success);
        this.subject.copyStoreFiles(this.catchupAddressProvider, this.expectedStoreId, this.expectedStoreFileStream, this.continueIndefinitely(), this.targetLocation);
        ((TimeoutStrategy.Timeout)Mockito.verify((Object)mockedTimeout, (VerificationMode)Mockito.never())).increment();
        ((TimeoutStrategy.Timeout)Mockito.verify((Object)mockedTimeout, (VerificationMode)Mockito.never())).getMillis();
    }

    @Test
    public void shouldFailIfTerminationConditionFails() throws CatchUpClientException {
        this.subject = new StoreCopyClient(this.catchUpClient, this.monitors, this.logProvider, (TimeoutStrategy)this.backOffStrategy);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.E_TOO_FAR_BEHIND));
        PrepareStoreCopyResponse initialListingOfFilesResponse = PrepareStoreCopyResponse.success((File[])this.serverFiles, (LongSet)this.indexIds, (long)-123L);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(PrepareStoreCopyRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)initialListingOfFilesResponse);
        try {
            this.subject.copyStoreFiles(this.catchupAddressProvider, this.expectedStoreId, this.expectedStoreFileStream, () -> () -> {
                throw new StoreCopyFailedException("This can't go on");
            }, this.targetLocation);
            Assert.fail((String)("Expected exception: " + StoreCopyFailedException.class));
        }
        catch (StoreCopyFailedException expectedException) {
            Assert.assertEquals((Object)"This can't go on", (Object)expectedException.getMessage());
            return;
        }
        Assert.fail((String)"Expected a StoreCopyFailedException");
    }

    @Test
    public void errorOnListingStore() throws CatchUpClientException, StoreCopyFailedException {
        PrepareStoreCopyResponse prepareStoreCopyResponse = PrepareStoreCopyResponse.error((PrepareStoreCopyResponse.Status)PrepareStoreCopyResponse.Status.E_LISTING_STORE);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)prepareStoreCopyResponse).thenThrow(new Throwable[]{new RuntimeException("Should not be accessible")});
        this.expectedException.expectMessage("Preparing store failed due to: E_LISTING_STORE");
        this.expectedException.expect(StoreCopyFailedException.class);
        this.subject.copyStoreFiles(this.catchupAddressProvider, this.expectedStoreId, this.expectedStoreFileStream, this.continueIndefinitely(), this.targetLocation);
    }

    @Test
    public void storeIdMismatchOnListing() throws CatchUpClientException, StoreCopyFailedException {
        PrepareStoreCopyResponse prepareStoreCopyResponse = PrepareStoreCopyResponse.error((PrepareStoreCopyResponse.Status)PrepareStoreCopyResponse.Status.E_STORE_ID_MISMATCH);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)prepareStoreCopyResponse).thenThrow(new Throwable[]{new RuntimeException("Should not be accessible")});
        this.expectedException.expectMessage("Preparing store failed due to: E_STORE_ID_MISMATCH");
        this.expectedException.expect(StoreCopyFailedException.class);
        this.subject.copyStoreFiles(this.catchupAddressProvider, this.expectedStoreId, this.expectedStoreFileStream, this.continueIndefinitely(), this.targetLocation);
    }

    @Test
    public void storeFileEventsAreReported() throws Exception {
        PrepareStoreCopyResponse prepareStoreCopyResponse = PrepareStoreCopyResponse.success((File[])this.serverFiles, (LongSet)this.indexIds, (long)-123L);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(PrepareStoreCopyRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)prepareStoreCopyResponse);
        StoreCopyFinishedResponse success = new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.SUCCESS);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(GetStoreFileRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)success);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(GetIndexFilesRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)success);
        StoreCopyClientMonitor storeCopyClientMonitor = (StoreCopyClientMonitor)Mockito.mock(StoreCopyClientMonitor.class);
        this.monitors.addMonitorListener((Object)storeCopyClientMonitor, new String[0]);
        this.subject.copyStoreFiles(this.catchupAddressProvider, this.expectedStoreId, this.expectedStoreFileStream, this.continueIndefinitely(), this.targetLocation);
        ((StoreCopyClientMonitor)Mockito.verify((Object)storeCopyClientMonitor)).startReceivingStoreFiles();
        for (File storeFileRequested : this.serverFiles) {
            ((StoreCopyClientMonitor)Mockito.verify((Object)storeCopyClientMonitor)).startReceivingStoreFile(Paths.get(this.targetLocation.toString(), storeFileRequested.toString()).toString());
            ((StoreCopyClientMonitor)Mockito.verify((Object)storeCopyClientMonitor)).finishReceivingStoreFile(Paths.get(this.targetLocation.toString(), storeFileRequested.toString()).toString());
        }
        ((StoreCopyClientMonitor)Mockito.verify((Object)storeCopyClientMonitor)).finishReceivingStoreFiles();
    }

    @Test
    public void snapshotEventsAreReported() throws Exception {
        PrepareStoreCopyResponse prepareStoreCopyResponse = PrepareStoreCopyResponse.success((File[])this.serverFiles, (LongSet)this.indexIds, (long)-123L);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(PrepareStoreCopyRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)prepareStoreCopyResponse);
        StoreCopyFinishedResponse success = new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.SUCCESS);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(GetStoreFileRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)success);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)ArgumentMatchers.any(GetIndexFilesRequest.class), (CatchUpResponseCallback)ArgumentMatchers.any())).thenReturn((Object)success);
        StoreCopyClientMonitor storeCopyClientMonitor = (StoreCopyClientMonitor)Mockito.mock(StoreCopyClientMonitor.class);
        this.monitors.addMonitorListener((Object)storeCopyClientMonitor, new String[0]);
        this.subject.copyStoreFiles(this.catchupAddressProvider, this.expectedStoreId, this.expectedStoreFileStream, this.continueIndefinitely(), this.targetLocation);
        ((StoreCopyClientMonitor)Mockito.verify((Object)storeCopyClientMonitor)).startReceivingIndexSnapshots();
        LongIterator iterator = this.indexIds.longIterator();
        while (iterator.hasNext()) {
            long indexSnapshotIdRequested = iterator.next();
            ((StoreCopyClientMonitor)Mockito.verify((Object)storeCopyClientMonitor)).startReceivingIndexSnapshot(indexSnapshotIdRequested);
            ((StoreCopyClientMonitor)Mockito.verify((Object)storeCopyClientMonitor)).finishReceivingIndexSnapshot(indexSnapshotIdRequested);
        }
        ((StoreCopyClientMonitor)Mockito.verify((Object)storeCopyClientMonitor)).finishReceivingIndexSnapshots();
    }

    private List<CatchUpRequest> getRequests() throws CatchUpClientException {
        ArgumentCaptor fileRequestArgumentCaptor = ArgumentCaptor.forClass(CatchUpRequest.class);
        ((CatchUpClient)Mockito.verify((Object)this.catchUpClient, (VerificationMode)Mockito.atLeast((int)0))).makeBlockingRequest((AdvertisedSocketAddress)ArgumentMatchers.any(), (CatchUpRequest)fileRequestArgumentCaptor.capture(), (CatchUpResponseCallback)ArgumentMatchers.any());
        return fileRequestArgumentCaptor.getAllValues();
    }

    private List<String> filenamesFromIndividualFileRequests(List<CatchUpRequest> fileRequests) {
        return fileRequests.stream().filter(GetStoreFileRequest.class::isInstance).map(obj -> (GetStoreFileRequest)obj).map(GetStoreFileRequest::file).map(File::getName).collect(Collectors.toList());
    }
}

