/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.File;
import java.util.stream.Stream;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyResponse;

public class PrepareStoreCopyResponseMarshalTest {
    private EmbeddedChannel embeddedChannel;

    @Before
    public void setup() {
        this.embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{new PrepareStoreCopyResponse.Encoder(), new PrepareStoreCopyResponse.Decoder()});
    }

    @Test
    public void transactionIdGetsTransmitted() {
        long transactionId = Long.MAX_VALUE;
        PrepareStoreCopyResponse prepareStoreCopyResponse = PrepareStoreCopyResponse.success((File[])new File[0], (LongSet)LongSets.immutable.empty(), (long)transactionId);
        PrepareStoreCopyResponseMarshalTest.sendToChannel(prepareStoreCopyResponse, this.embeddedChannel);
        PrepareStoreCopyResponse readPrepareStoreCopyResponse = (PrepareStoreCopyResponse)this.embeddedChannel.readInbound();
        Assert.assertEquals((long)prepareStoreCopyResponse.lastTransactionId(), (long)readPrepareStoreCopyResponse.lastTransactionId());
    }

    @Test
    public void fileListGetsTransmitted() {
        File[] files = new File[]{new File("File a.txt"), new File("file-b"), new File("aoifnoasndfosidfoisndfoisnodainfsonidfaosiidfna"), new File("")};
        PrepareStoreCopyResponse prepareStoreCopyResponse = PrepareStoreCopyResponse.success((File[])files, (LongSet)LongSets.immutable.empty(), (long)0L);
        PrepareStoreCopyResponseMarshalTest.sendToChannel(prepareStoreCopyResponse, this.embeddedChannel);
        PrepareStoreCopyResponse readPrepareStoreCopyResponse = (PrepareStoreCopyResponse)this.embeddedChannel.readInbound();
        Assert.assertEquals((long)prepareStoreCopyResponse.getFiles().length, (long)readPrepareStoreCopyResponse.getFiles().length);
        for (File file : files) {
            Assert.assertEquals((long)1L, (long)Stream.of(readPrepareStoreCopyResponse.getFiles()).map(File::getName).filter(f -> f.equals(file.getName())).count());
        }
    }

    @Test
    public void descriptorsGetTransmitted() {
        File[] files = new File[]{new File("File a.txt"), new File("file-b"), new File("aoifnoasndfosidfoisndfoisnodainfsonidfaosiidfna"), new File("")};
        ImmutableLongSet indexIds = LongSets.immutable.of(13L);
        PrepareStoreCopyResponse prepareStoreCopyResponse = PrepareStoreCopyResponse.success((File[])files, (LongSet)indexIds, (long)1L);
        PrepareStoreCopyResponseMarshalTest.sendToChannel(prepareStoreCopyResponse, this.embeddedChannel);
        PrepareStoreCopyResponse readPrepareStoreCopyResponse = (PrepareStoreCopyResponse)this.embeddedChannel.readInbound();
        Assert.assertEquals((long)prepareStoreCopyResponse.getFiles().length, (long)readPrepareStoreCopyResponse.getFiles().length);
        for (File file : files) {
            Assert.assertEquals((long)1L, (long)Stream.of(readPrepareStoreCopyResponse.getFiles()).map(File::getName).filter(f -> f.equals(file.getName())).count());
        }
        Assert.assertEquals((Object)prepareStoreCopyResponse.getIndexIds(), (Object)readPrepareStoreCopyResponse.getIndexIds());
    }

    private static void sendToChannel(PrepareStoreCopyResponse prepareStoreCopyResponse, EmbeddedChannel embeddedChannel) {
        embeddedChannel.writeOutbound(new Object[]{prepareStoreCopyResponse});
        ByteBuf object = (ByteBuf)embeddedChannel.readOutbound();
        embeddedChannel.writeInbound(new Object[]{object});
    }
}

