/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyFiles;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyFilesProvider;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyRequest;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyRequestHandler;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreResource;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.util.Dependencies;

public class PrepareStoreCopyRequestHandlerTest {
    private static final StoreId STORE_ID_MATCHING = new StoreId(1L, 2L, 3L, 4L);
    private static final StoreId STORE_ID_MISMATCHING = new StoreId(5000L, 6000L, 7000L, 8000L);
    private final ChannelHandlerContext channelHandlerContext = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
    private EmbeddedChannel embeddedChannel;
    private static final CheckPointer checkPointer = (CheckPointer)Mockito.mock(CheckPointer.class);
    private static final NeoStoreDataSource neoStoreDataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
    private CatchupServerProtocol catchupServerProtocol;
    private final PrepareStoreCopyFiles prepareStoreCopyFiles = (PrepareStoreCopyFiles)Mockito.mock(PrepareStoreCopyFiles.class);

    @Before
    public void setup() {
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)checkPointer);
        StoreCopyCheckPointMutex storeCopyCheckPointMutex = new StoreCopyCheckPointMutex();
        Mockito.when((Object)neoStoreDataSource.getStoreCopyCheckPointMutex()).thenReturn((Object)storeCopyCheckPointMutex);
        Mockito.when((Object)neoStoreDataSource.getDependencyResolver()).thenReturn((Object)dependencies);
        PrepareStoreCopyRequestHandler subject = this.createHandler();
        this.embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{subject});
    }

    @Test
    public void shouldGiveErrorResponseIfStoreMismatch() {
        this.embeddedChannel.writeInbound(new Object[]{new PrepareStoreCopyRequest(STORE_ID_MISMATCHING)});
        Assert.assertEquals((Object)ResponseMessageType.PREPARE_STORE_COPY_RESPONSE, (Object)this.embeddedChannel.readOutbound());
        PrepareStoreCopyResponse response = PrepareStoreCopyResponse.error((PrepareStoreCopyResponse.Status)PrepareStoreCopyResponse.Status.E_STORE_ID_MISMATCH);
        Assert.assertEquals((Object)response, (Object)this.embeddedChannel.readOutbound());
        Assert.assertTrue((boolean)this.catchupServerProtocol.isExpecting((Enum)CatchupServerProtocol.State.MESSAGE_TYPE));
    }

    @Test
    public void shouldGetSuccessfulResponseFromPrepareStoreCopyRequest() throws Exception {
        ImmutableLongSet indexIds = LongSets.immutable.of(1L);
        File[] files = new File[]{new File("file")};
        long lastCheckpoint = 1L;
        this.configureProvidedStoreCopyFiles(new StoreResource[0], files, (LongSet)indexIds, lastCheckpoint);
        this.embeddedChannel.writeInbound(new Object[]{this.channelHandlerContext, new PrepareStoreCopyRequest(STORE_ID_MATCHING)});
        Assert.assertEquals((Object)ResponseMessageType.PREPARE_STORE_COPY_RESPONSE, (Object)this.embeddedChannel.readOutbound());
        PrepareStoreCopyResponse response = PrepareStoreCopyResponse.success((File[])files, (LongSet)indexIds, (long)lastCheckpoint);
        Assert.assertEquals((Object)response, (Object)this.embeddedChannel.readOutbound());
        Assert.assertTrue((boolean)this.catchupServerProtocol.isExpecting((Enum)CatchupServerProtocol.State.MESSAGE_TYPE));
    }

    @Test
    public void shouldRetainLockWhileStreaming() throws Exception {
        ChannelPromise channelPromise = this.embeddedChannel.newPromise();
        ChannelHandlerContext channelHandlerContext = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)channelHandlerContext.writeAndFlush(ArgumentMatchers.any(PrepareStoreCopyResponse.class))).thenReturn((Object)channelPromise);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Mockito.when((Object)neoStoreDataSource.getStoreCopyCheckPointMutex()).thenReturn((Object)new StoreCopyCheckPointMutex((ReadWriteLock)lock));
        PrepareStoreCopyRequestHandler subjectHandler = this.createHandler();
        ImmutableLongSet indexIds = LongSets.immutable.of(42L);
        File[] files = new File[]{new File("file")};
        long lastCheckpoint = 1L;
        this.configureProvidedStoreCopyFiles(new StoreResource[0], files, (LongSet)indexIds, lastCheckpoint);
        subjectHandler.channelRead0(channelHandlerContext, new PrepareStoreCopyRequest(STORE_ID_MATCHING));
        Assert.assertEquals((long)1L, (long)lock.getReadLockCount());
        channelPromise.setSuccess();
        Assert.assertEquals((long)0L, (long)lock.getReadLockCount());
    }

    private PrepareStoreCopyRequestHandler createHandler() {
        this.catchupServerProtocol = new CatchupServerProtocol();
        this.catchupServerProtocol.expect((Enum)CatchupServerProtocol.State.PREPARE_STORE_COPY);
        Supplier<NeoStoreDataSource> dataSourceSupplier = () -> neoStoreDataSource;
        Mockito.when((Object)neoStoreDataSource.getStoreId()).thenReturn((Object)new org.neo4j.kernel.impl.store.StoreId(1L, 2L, 5L, 3L, 4L));
        PrepareStoreCopyFilesProvider prepareStoreCopyFilesProvider = (PrepareStoreCopyFilesProvider)Mockito.mock(PrepareStoreCopyFilesProvider.class);
        Mockito.when((Object)prepareStoreCopyFilesProvider.prepareStoreCopyFiles((NeoStoreDataSource)ArgumentMatchers.any())).thenReturn((Object)this.prepareStoreCopyFiles);
        return new PrepareStoreCopyRequestHandler(this.catchupServerProtocol, dataSourceSupplier, prepareStoreCopyFilesProvider);
    }

    private void configureProvidedStoreCopyFiles(StoreResource[] atomicFiles, File[] files, LongSet indexIds, long lastCommitedTx) throws IOException {
        Mockito.when((Object)this.prepareStoreCopyFiles.getAtomicFilesSnapshot()).thenReturn((Object)atomicFiles);
        Mockito.when((Object)this.prepareStoreCopyFiles.getNonAtomicIndexIds()).thenReturn((Object)indexIds);
        Mockito.when((Object)this.prepareStoreCopyFiles.listReplayableFiles()).thenReturn((Object)files);
        Mockito.when((Object)checkPointer.lastCheckPointedTransactionId()).thenReturn((Object)lastCommitedTx);
    }
}

