/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreFileRequest;
import org.neo4j.causalclustering.identity.StoreId;

public class GetStoreFileMarshalTest {
    EmbeddedChannel embeddedChannel;
    private static final StoreId expectedStore = new StoreId(1L, 2L, 3L, 4L);
    private static final File expectedFile = new File("abc.123");
    private static final Long expectedLastTransaction = 1234L;

    @Before
    public void setup() {
        this.embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{new GetStoreFileRequest.Encoder(), new GetStoreFileRequest.Decoder()});
    }

    @Test
    public void getsTransmitted() {
        GetStoreFileRequest expectedStoreRequest = new GetStoreFileRequest(expectedStore, expectedFile, expectedLastTransaction.longValue());
        GetStoreFileMarshalTest.sendToChannel(expectedStoreRequest, this.embeddedChannel);
        GetStoreFileRequest actualStoreRequest = (GetStoreFileRequest)this.embeddedChannel.readInbound();
        Assert.assertEquals((Object)expectedStore, (Object)actualStoreRequest.expectedStoreId());
        Assert.assertEquals((Object)expectedFile, (Object)actualStoreRequest.file());
        Assert.assertEquals((long)expectedLastTransaction, (long)actualStoreRequest.requiredTransactionId());
    }

    private static void sendToChannel(GetStoreFileRequest getStoreFileRequest, EmbeddedChannel embeddedChannel) {
        embeddedChannel.writeOutbound(new Object[]{getStoreFileRequest});
        ByteBuf object = (ByteBuf)embeddedChannel.readOutbound();
        embeddedChannel.writeInbound(new Object[]{object});
    }
}

