/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.causalclustering.catchup.storecopy.GetIndexFilesRequest;
import org.neo4j.causalclustering.identity.StoreId;

public class GetIndexFilesRequestMarshalTest {
    private EmbeddedChannel embeddedChannel;
    private static final StoreId expectedStore = new StoreId(1L, 2L, 3L, 4L);
    private static final long exepctedIndexId = 13L;
    private static final Long expectedLastTransaction = 1234L;

    @Before
    public void setup() {
        this.embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{new GetIndexFilesRequest.Encoder(), new GetIndexFilesRequest.Decoder()});
    }

    @Test
    public void getsTransmitted() {
        GetIndexFilesRequest expectedIndexSnapshotRequest = new GetIndexFilesRequest(expectedStore, 13L, expectedLastTransaction.longValue());
        GetIndexFilesRequestMarshalTest.sendToChannel(expectedIndexSnapshotRequest, this.embeddedChannel);
        GetIndexFilesRequest actualIndexRequest = (GetIndexFilesRequest)this.embeddedChannel.readInbound();
        Assert.assertEquals((Object)expectedStore, (Object)actualIndexRequest.expectedStoreId());
        Assert.assertEquals((long)13L, (long)actualIndexRequest.indexId());
        Assert.assertEquals((long)expectedLastTransaction, (long)actualIndexRequest.requiredTransactionId());
    }

    private static void sendToChannel(GetIndexFilesRequest expectedIndexSnapshotRequest, EmbeddedChannel embeddedChannel) {
        embeddedChannel.writeOutbound(new Object[]{expectedIndexSnapshotRequest});
        ByteBuf object = (ByteBuf)embeddedChannel.readOutbound();
        embeddedChannel.writeInbound(new Object[]{object});
    }
}

