/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;

class FakeFile {
    private File file;
    private String filename;
    private String content;
    private int remainingNoResponse;
    private int remainingFailed;
    private Path relativePath;

    FakeFile(String name, String content) {
        this.setFilename(name);
        this.content = content;
    }

    public void setFilename(String filename) {
        this.filename = filename;
        this.file = this.getRelativePath().resolve(filename).toFile();
    }

    public void setFile(File file) {
        this.filename = file.getName();
        this.file = file;
    }

    private Path getRelativePath() {
        return Optional.ofNullable(this.relativePath).orElse(new File(".").toPath());
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    int getRemainingFailed() {
        return this.remainingFailed;
    }

    void setRemainingFailed(int remainingFailed) {
        this.remainingFailed = remainingFailed;
    }
}

