/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchupClientBuilder;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyResponse;
import org.neo4j.causalclustering.catchup.storecopy.SimpleCatchupClient;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClientIT;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.TestCatchupServer;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class CatchupServerIT {
    private static final String EXISTING_FILE_NAME = "neostore.nodestore.db";
    private static final StoreId WRONG_STORE_ID = new StoreId(123L, 221L, 3131L, 45678L);
    private static final LogProvider LOG_PROVIDER = NullLogProvider.getInstance();
    private static final String PROP_NAME = "name";
    private static final String PROP = "prop";
    public static final Label LABEL = Label.label((String)"MyLabel");
    private static final String INDEX = "index";
    private GraphDatabaseAPI graphDb;
    private TestCatchupServer catchupServer;
    private File temporaryDirectory;
    private PageCache pageCache;
    @Rule
    public DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fileSystemRule);
    private CatchUpClient catchupClient;
    private DefaultFileSystemAbstraction fsa = (DefaultFileSystemAbstraction)this.fileSystemRule.get();

    @Before
    public void startDb() throws Throwable {
        this.temporaryDirectory = this.testDirectory.directory();
        this.graphDb = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fsa).newEmbeddedDatabase(this.testDirectory.graphDbDir());
        this.createLegacyIndex();
        this.createPropertyIndex();
        this.addData(this.graphDb);
        this.catchupServer = new TestCatchupServer((FileSystemAbstraction)this.fsa, this.graphDb);
        this.catchupServer.start();
        this.catchupClient = new CatchupClientBuilder().build();
        this.catchupClient.start();
        this.pageCache = (PageCache)this.graphDb.getDependencyResolver().resolveDependency(PageCache.class);
    }

    @After
    public void stopDb() throws Throwable {
        this.pageCache.flushAndForce();
        if (this.graphDb != null) {
            this.graphDb.shutdown();
        }
        if (this.catchupClient != null) {
            this.catchupClient.stop();
        }
        if (this.catchupServer != null) {
            this.catchupServer.stop();
        }
    }

    @Test
    public void shouldListExpectedFilesCorrectly() throws Exception {
        NeoStoreDataSource neoStoreDataSource = CatchupServerIT.getNeoStoreDataSource(this.graphDb);
        SimpleCatchupClient simpleCatchupClient = new SimpleCatchupClient(this.graphDb, (FileSystemAbstraction)this.fsa, this.catchupClient, this.catchupServer, this.temporaryDirectory, LOG_PROVIDER);
        PrepareStoreCopyResponse prepareStoreCopyResponse = simpleCatchupClient.requestListOfFilesFromServer();
        simpleCatchupClient.close();
        this.listOfDownloadedFilesMatchesServer(neoStoreDataSource, prepareStoreCopyResponse.getFiles());
        List<File> expectedCountStoreFiles = this.listServerExpectedNonReplayableFiles(neoStoreDataSource);
        for (File storeFileSnapshot : expectedCountStoreFiles) {
            this.fileContentEquals(this.databaseFileToClientFile(storeFileSnapshot), storeFileSnapshot);
        }
        this.assertTransactionIdMatches(prepareStoreCopyResponse.lastTransactionId());
        Assert.assertTrue((String)("Expected an empty set of ids. Found size " + prepareStoreCopyResponse.getIndexIds().size()), (boolean)prepareStoreCopyResponse.getIndexIds().isEmpty());
    }

    @Test
    public void shouldCommunicateErrorIfStoreIdDoesNotMatchRequest() throws Exception {
        this.addData(this.graphDb);
        SimpleCatchupClient simpleCatchupClient = new SimpleCatchupClient(this.graphDb, (FileSystemAbstraction)this.fsa, this.catchupClient, this.catchupServer, this.temporaryDirectory, LOG_PROVIDER);
        PrepareStoreCopyResponse prepareStoreCopyResponse = simpleCatchupClient.requestListOfFilesFromServer(WRONG_STORE_ID);
        simpleCatchupClient.close();
        Assert.assertEquals((Object)PrepareStoreCopyResponse.Status.E_STORE_ID_MISMATCH, (Object)prepareStoreCopyResponse.status());
        Object[] remoteFiles = prepareStoreCopyResponse.getFiles();
        Assert.assertArrayEquals((Object[])new File[0], (Object[])remoteFiles);
    }

    @Test
    public void individualFileCopyWorks() throws Exception {
        this.addData(this.graphDb);
        File existingFile = new File(this.temporaryDirectory, EXISTING_FILE_NAME);
        SimpleCatchupClient simpleCatchupClient = new SimpleCatchupClient(this.graphDb, (FileSystemAbstraction)this.fsa, this.catchupClient, this.catchupServer, this.temporaryDirectory, LOG_PROVIDER);
        this.pageCache.flushAndForce();
        StoreCopyFinishedResponse storeCopyFinishedResponse = simpleCatchupClient.requestIndividualFile(existingFile);
        simpleCatchupClient.close();
        Assert.assertEquals((Object)StoreCopyFinishedResponse.Status.SUCCESS, (Object)storeCopyFinishedResponse.status());
        this.fileContentEquals(this.clientFileToDatabaseFile(existingFile), existingFile);
    }

    @Test
    public void individualIndexSnapshotCopyWorks() throws Exception {
        NeoStoreDataSource neoStoreDataSource = CatchupServerIT.getNeoStoreDataSource(this.graphDb);
        List<File> expectingFiles = neoStoreDataSource.getNeoStoreFileListing().builder().excludeAll().includeSchemaIndexStoreFiles().build().stream().map(StoreFileMetadata::file).collect(Collectors.toList());
        SimpleCatchupClient simpleCatchupClient = new SimpleCatchupClient(this.graphDb, (FileSystemAbstraction)this.fsa, this.catchupClient, this.catchupServer, this.temporaryDirectory, LOG_PROVIDER);
        LongIterator indexIds = this.getExpectedIndexIds(neoStoreDataSource).longIterator();
        while (indexIds.hasNext()) {
            long indexId = indexIds.next();
            StoreCopyFinishedResponse response = simpleCatchupClient.requestIndexSnapshot(indexId);
            simpleCatchupClient.close();
            Assert.assertEquals((Object)StoreCopyFinishedResponse.Status.SUCCESS, (Object)response.status());
        }
        this.fileContentEquals(expectingFiles);
    }

    @Test
    public void individualFileCopyFailsIfStoreIdMismatch() throws Exception {
        this.addData(this.graphDb);
        File expectedExistingFile = new File(this.graphDb.getStoreDir(), EXISTING_FILE_NAME);
        SimpleCatchupClient simpleCatchupClient = new SimpleCatchupClient(this.graphDb, (FileSystemAbstraction)this.fsa, this.catchupClient, this.catchupServer, this.temporaryDirectory, LOG_PROVIDER);
        StoreCopyFinishedResponse storeCopyFinishedResponse = simpleCatchupClient.requestIndividualFile(expectedExistingFile, WRONG_STORE_ID);
        simpleCatchupClient.close();
        Assert.assertEquals((Object)StoreCopyFinishedResponse.Status.E_STORE_ID_MISMATCH, (Object)storeCopyFinishedResponse.status());
    }

    private void assertTransactionIdMatches(long lastTxId) {
        long expectedTransactionId = CatchupServerIT.getCheckPointer(this.graphDb).lastCheckPointedTransactionId();
        Assert.assertEquals((long)expectedTransactionId, (long)lastTxId);
    }

    private void fileContentEquals(Collection<File> countStore) throws IOException {
        for (File file : countStore) {
            this.fileContentEquals(this.databaseFileToClientFile(file), file);
        }
    }

    private File databaseFileToClientFile(File file) throws IOException {
        String relativePathToDatabaseDir = FileUtils.relativePath((File)new File(this.temporaryDirectory, "graph-db"), (File)file);
        return new File(this.temporaryDirectory, relativePathToDatabaseDir);
    }

    private File clientFileToDatabaseFile(File file) throws IOException {
        String relativePathToDatabaseDir = FileUtils.relativePath((File)this.temporaryDirectory, (File)file);
        return new File(new File(this.temporaryDirectory, "graph-db"), relativePathToDatabaseDir);
    }

    private void fileContentEquals(File fileA, File fileB) throws IOException {
        Assert.assertNotEquals((Object)fileA.getPath(), (Object)fileB.getPath());
        String message = String.format("Expected file: %s\ndoes not match actual file: %s", fileA, fileB);
        Assert.assertEquals((String)message, (Object)StoreCopyClientIT.fileContent(fileA, (FileSystemAbstraction)this.fsa), (Object)StoreCopyClientIT.fileContent(fileB, (FileSystemAbstraction)this.fsa));
    }

    private void listOfDownloadedFilesMatchesServer(NeoStoreDataSource neoStoreDataSource, File[] files) throws IOException {
        List<String> expectedStoreFiles = this.getExpectedStoreFiles(neoStoreDataSource);
        List givenFile = Arrays.stream(files).map(File::getName).collect(Collectors.toList());
        Assert.assertThat(givenFile, (Matcher)Matchers.containsInAnyOrder((Object[])expectedStoreFiles.toArray(new String[givenFile.size()])));
    }

    private LongSet getExpectedIndexIds(NeoStoreDataSource neoStoreDataSource) {
        return neoStoreDataSource.getNeoStoreFileListing().getNeoStoreFileIndexListing().getIndexIds();
    }

    /*
     * Exception decompiling
     */
    private List<File> listServerExpectedNonReplayableFiles(NeoStoreDataSource neoStoreDataSource) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> getExpectedStoreFiles(NeoStoreDataSource neoStoreDataSource) throws IOException {
        NeoStoreFileListing.StoreFileListingBuilder builder = neoStoreDataSource.getNeoStoreFileListing().builder();
        builder.excludeLogFiles().excludeExplicitIndexStoreFiles().excludeSchemaIndexStoreFiles().excludeAdditionalProviders();
        try (Stream stream = builder.build().stream();){
            List<String> list = stream.filter(CatchupServerIT.isCountFile().negate()).map(sfm -> sfm.file().getName()).collect(Collectors.toList());
            return list;
        }
    }

    private static Predicate<StoreFileMetadata> isCountFile() {
        return storeFileMetadata -> StoreType.typeOf((String)storeFileMetadata.file().getName()).filter(f -> f == StoreType.COUNTS).isPresent();
    }

    private void addData(GraphDatabaseAPI graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            Node node = graphDb.createNode();
            node.addLabel(LABEL);
            node.setProperty(PROP_NAME, (Object)"Neo");
            node.setProperty(PROP, (Object)(Math.random() * 10000.0));
            graphDb.createNode().createRelationshipTo(node, RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
    }

    private void createPropertyIndex() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.graphDb.schema().indexFor(LABEL).on(PROP_NAME).create();
            tx.success();
        }
    }

    private void createLegacyIndex() {
        try (Transaction tx = this.graphDb.beginTx();){
            Index nodeIndex = this.graphDb.index().forNodes(INDEX);
            nodeIndex.add((PropertyContainer)this.graphDb.createNode(), "some-key", (Object)"som-value");
            tx.success();
        }
    }

    private static CheckPointer getCheckPointer(GraphDatabaseAPI graphDb) {
        return (CheckPointer)graphDb.getDependencyResolver().resolveDependency(CheckPointer.class);
    }

    private static NeoStoreDataSource getNeoStoreDataSource(GraphDatabaseAPI graphDb) {
        return (NeoStoreDataSource)graphDb.getDependencyResolver().resolveDependency(NeoStoreDataSource.class);
    }
}

