/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.catchup.RequestMessageType;

public class RequestMessageTypeTest {
    @Test
    public void shouldHaveExpectedValues() {
        RequestMessageType[] givenStates = RequestMessageType.values();
        RequestMessageType[] exepctedStates = new RequestMessageType[]{RequestMessageType.TX_PULL_REQUEST, RequestMessageType.STORE, RequestMessageType.CORE_SNAPSHOT, RequestMessageType.STORE_ID, RequestMessageType.PREPARE_STORE_COPY, RequestMessageType.STORE_FILE, RequestMessageType.INDEX_SNAPSHOT, RequestMessageType.UNKNOWN};
        byte[] expectedValues = new byte[]{1, 2, 3, 4, 5, 6, 7, -108};
        Assert.assertEquals((long)exepctedStates.length, (long)givenStates.length);
        Assert.assertEquals((long)exepctedStates.length, (long)expectedValues.length);
        for (int i = 0; i < givenStates.length; ++i) {
            RequestMessageType exepctedState = exepctedStates[i];
            RequestMessageType givenState = givenStates[i];
            Assert.assertEquals((String)String.format("Expected %s git %s", givenState, exepctedState), (long)givenState.messageType(), (long)exepctedState.messageType());
            Assert.assertEquals((long)givenState.messageType(), (long)expectedValues[i]);
        }
    }
}

