/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.util.Optional;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionStrategy;

public class TypicallyConnectToRandomReadReplicaStrategy
extends UpstreamDatabaseSelectionStrategy {
    private final ModuloCounter counter = new ModuloCounter(10);

    public TypicallyConnectToRandomReadReplicaStrategy() {
        super("typically-connect-to-random-read-replica", new String[0]);
    }

    @Override
    public Optional<MemberId> upstreamDatabase() throws UpstreamDatabaseSelectionException {
        if (this.counter.shouldReturnCoreMemberId()) {
            return this.topologyService.coreServers().anyCoreMemberId();
        }
        return this.topologyService.readReplicas().anyReadReplicaMemberId();
    }

    private static class ModuloCounter {
        private final int modulo;
        private int counter;

        ModuloCounter(int modulo) {
            this.modulo = modulo - 1;
        }

        boolean shouldReturnCoreMemberId() {
            this.counter = (this.counter + 1) % this.modulo;
            return this.counter == 0;
        }
    }
}

