/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.util.Optional;
import java.util.Random;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionStrategy;

public class ConnectToRandomCoreServerStrategy
extends UpstreamDatabaseSelectionStrategy {
    private final Random random = new Random();

    public ConnectToRandomCoreServerStrategy() {
        super("connect-to-random-core-server", new String[0]);
    }

    @Override
    public Optional<MemberId> upstreamDatabase() throws UpstreamDatabaseSelectionException {
        CoreTopology coreTopology = this.topologyService.coreServers();
        if (coreTopology.members().size() == 0) {
            throw new UpstreamDatabaseSelectionException("No core servers available");
        }
        int skippedServers = this.random.nextInt(coreTopology.members().size());
        return coreTopology.members().keySet().stream().skip(skippedServers).findFirst();
    }
}

