/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.readreplica.ConnectRandomlyToServerGroupImpl;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionStrategy;

public class ConnectRandomlyToServerGroupStrategy
extends UpstreamDatabaseSelectionStrategy {
    static final String NAME = "connect-randomly-to-server-group";
    private ConnectRandomlyToServerGroupImpl strategyImpl;

    public ConnectRandomlyToServerGroupStrategy() {
        super(NAME, new String[0]);
    }

    @Override
    void init() {
        List groups = (List)this.config.get(CausalClusteringSettings.connect_randomly_to_server_group_strategy);
        this.strategyImpl = new ConnectRandomlyToServerGroupImpl(groups, this.topologyService, this.myself);
        if (groups.isEmpty()) {
            this.log.warn("No server groups configured for upstream strategy " + this.readableName + ". Strategy will not find upstream servers.");
        } else {
            String readableGroups = groups.stream().collect(Collectors.joining(", "));
            this.log.info("Upstream selection strategy " + this.readableName + " configured with server groups " + readableGroups);
        }
    }

    @Override
    public Optional<MemberId> upstreamDatabase() throws UpstreamDatabaseSelectionException {
        return this.strategyImpl.upstreamDatabase();
    }
}

