/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.buffer.ByteBuf;
import java.io.Flushable;
import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;

public class NetworkFlushableByteBuf
implements FlushableChannel {
    private final ByteBuf delegate;

    public NetworkFlushableByteBuf(ByteBuf byteBuf) {
        this.delegate = byteBuf;
    }

    public FlushableChannel put(byte value) throws IOException {
        this.delegate.writeByte((int)value);
        return this;
    }

    public FlushableChannel putShort(short value) throws IOException {
        this.delegate.writeShort((int)value);
        return this;
    }

    public FlushableChannel putInt(int value) throws IOException {
        this.delegate.writeInt(value);
        return this;
    }

    public FlushableChannel putLong(long value) throws IOException {
        this.delegate.writeLong(value);
        return this;
    }

    public FlushableChannel putFloat(float value) throws IOException {
        this.delegate.writeFloat(value);
        return this;
    }

    public FlushableChannel putDouble(double value) throws IOException {
        this.delegate.writeDouble(value);
        return this;
    }

    public FlushableChannel put(byte[] value, int length) throws IOException {
        this.delegate.writeBytes(value, 0, length);
        return this;
    }

    public void close() throws IOException {
    }

    public Flushable prepareForFlush() {
        return null;
    }

    public ByteBuf buffer() {
        return this.delegate;
    }
}

