/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing.procedure;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.load_balancing.Endpoint;
import org.neo4j.causalclustering.load_balancing.LoadBalancingResult;
import org.neo4j.causalclustering.load_balancing.Util;
import org.neo4j.causalclustering.load_balancing.procedure.ParameterNames;
import org.neo4j.causalclustering.load_balancing.procedure.ProcedureNames;
import org.neo4j.causalclustering.load_balancing.procedure.ResultFormatV1;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class GetServersProcedureForSingleDC
implements CallableProcedure {
    private final String DESCRIPTION = "Returns cluster endpoints and their capabilities for single data center setup.";
    private final ProcedureSignature procedureSignature = ProcedureSignature.procedureSignature((String[])ProcedureNames.GET_SERVERS_V2.fullyQualifiedProcedureName()).in(ParameterNames.CONTEXT.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTMap).out(ParameterNames.TTL.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).out(ParameterNames.SERVERS.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTMap)).description("Returns cluster endpoints and their capabilities for single data center setup.").build();
    private final TopologyService topologyService;
    private final LeaderLocator leaderLocator;
    private final Config config;
    private final Log log;

    public GetServersProcedureForSingleDC(TopologyService topologyService, LeaderLocator leaderLocator, Config config, LogProvider logProvider) {
        this.topologyService = topologyService;
        this.leaderLocator = leaderLocator;
        this.config = config;
        this.log = logProvider.getLog(this.getClass());
    }

    public ProcedureSignature signature() {
        return this.procedureSignature;
    }

    public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input) throws ProcedureException {
        List<Endpoint> routeEndpoints = this.routeEndpoints();
        List<Endpoint> writeEndpoints = this.writeEndpoints();
        List<Endpoint> readEndpoints = this.readEndpoints();
        return RawIterator.of((Object[])new Object[][]{ResultFormatV1.build(new LoadBalancingResult(routeEndpoints, writeEndpoints, readEndpoints, ((Duration)this.config.get(CausalClusteringSettings.cluster_routing_ttl)).toMillis()))});
    }

    private Optional<AdvertisedSocketAddress> leaderBoltAddress() {
        MemberId leader;
        try {
            leader = this.leaderLocator.getLeader();
        }
        catch (NoLeaderFoundException e) {
            this.log.debug("No leader server found. This can happen during a leader switch. No write end points available");
            return Optional.empty();
        }
        return this.topologyService.coreServers().find(leader).map(Util.extractBoltAddress());
    }

    private List<Endpoint> routeEndpoints() {
        Stream<AdvertisedSocketAddress> routers = this.topologyService.coreServers().members().values().stream().map(Util.extractBoltAddress());
        List<Endpoint> routeEndpoints = routers.map(Endpoint::route).collect(Collectors.toList());
        Collections.shuffle(routeEndpoints);
        return routeEndpoints;
    }

    private List<Endpoint> writeEndpoints() {
        return Util.asList(this.leaderBoltAddress().map(Endpoint::write));
    }

    private List<Endpoint> readEndpoints() {
        List readReplicas = this.topologyService.readReplicas().allMemberInfo().stream().map(Util.extractBoltAddress()).collect(Collectors.toList());
        boolean addFollowers = readReplicas.isEmpty() || (Boolean)this.config.get(CausalClusteringSettings.cluster_allow_reads_on_followers) != false;
        Stream<Object> readCore = addFollowers ? this.coreReadEndPoints() : Stream.empty();
        List<Endpoint> readEndPoints = Stream.concat(readReplicas.stream(), readCore).map(Endpoint::read).collect(Collectors.toList());
        Collections.shuffle(readEndPoints);
        return readEndPoints;
    }

    private Stream<AdvertisedSocketAddress> coreReadEndPoints() {
        Optional<AdvertisedSocketAddress> leader = this.leaderBoltAddress();
        Collection<CoreServerInfo> coreServerInfo = this.topologyService.coreServers().members().values();
        Stream<AdvertisedSocketAddress> boltAddresses = this.topologyService.coreServers().members().values().stream().map(Util.extractBoltAddress());
        if (leader.isPresent() && coreServerInfo.size() > 1) {
            AdvertisedSocketAddress advertisedSocketAddress = leader.get();
            return boltAddresses.filter(address -> !advertisedSocketAddress.equals(address));
        }
        return boltAddresses;
    }
}

