/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing.plugins.server_policies;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.load_balancing.filters.Filter;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.FilterConfigParser;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.FilteringPolicy;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.InvalidFilterSpecification;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.Policies;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.ServerInfo;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;

class FilteringPolicyLoader {
    private FilteringPolicyLoader() {
    }

    static Policies load(Config config, String pluginName, Log log) throws InvalidFilterSpecification {
        Policies policies = new Policies(log);
        String prefix = FilteringPolicyLoader.policyPrefix(pluginName);
        Map rawConfig = config.getRaw();
        Set configKeys = rawConfig.keySet().stream().filter(e -> e.startsWith(prefix)).collect(Collectors.toSet());
        for (String configKey : configKeys) {
            String policyName = configKey.substring(prefix.length());
            String filterSpec = (String)rawConfig.get(configKey);
            Filter<ServerInfo> filter = FilterConfigParser.parse(filterSpec);
            policies.addPolicy(policyName, new FilteringPolicy(filter));
        }
        return policies;
    }

    private static String policyPrefix(String pluginName) {
        return String.format("%s.%s.", CausalClusteringSettings.load_balancing_config.name(), pluginName);
    }
}

