/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing.plugins.server_policies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.load_balancing.filters.Filter;
import org.neo4j.causalclustering.load_balancing.filters.FilterChain;
import org.neo4j.causalclustering.load_balancing.filters.FirstValidRule;
import org.neo4j.causalclustering.load_balancing.filters.IdentityFilter;
import org.neo4j.causalclustering.load_balancing.filters.MinimumCountFilter;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.AnyGroupFilter;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.HaltFilter;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.InvalidFilterSpecification;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.ServerInfo;

public class FilterConfigParser {
    private FilterConfigParser() {
    }

    private static Filter<ServerInfo> filterFor(String filterName, String[] args) throws InvalidFilterSpecification {
        switch (filterName) {
            case "groups": {
                if (args.length < 1) {
                    throw new InvalidFilterSpecification(String.format("Invalid number of arguments for filter '%s': %d", filterName, args.length));
                }
                for (String group : args) {
                    if (!group.matches("\\W")) continue;
                    throw new InvalidFilterSpecification(String.format("Invalid group for filter '%s': '%s'", filterName, group));
                }
                return new AnyGroupFilter(args);
            }
            case "min": {
                int minCount;
                if (args.length != 1) {
                    throw new InvalidFilterSpecification(String.format("Invalid number of arguments for filter '%s': %d", filterName, args.length));
                }
                try {
                    minCount = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    throw new InvalidFilterSpecification(String.format("Invalid argument for filter '%s': '%s'", filterName, args[0]), e);
                }
                return new MinimumCountFilter<ServerInfo>(minCount);
            }
            case "all": {
                if (args.length != 0) {
                    throw new InvalidFilterSpecification(String.format("Invalid number of arguments for filter '%s': %d", filterName, args.length));
                }
                return IdentityFilter.as();
            }
            case "halt": {
                if (args.length != 0) {
                    throw new InvalidFilterSpecification(String.format("Invalid number of arguments for filter '%s': %d", filterName, args.length));
                }
                return HaltFilter.INSTANCE;
            }
        }
        throw new InvalidFilterSpecification("Unknown filter: " + filterName);
    }

    public static Filter<ServerInfo> parse(String filterConfig) throws InvalidFilterSpecification {
        if (filterConfig.length() == 0) {
            throw new InvalidFilterSpecification("Filter config is empty");
        }
        ArrayList rules = new ArrayList();
        String[] ruleSpecs = filterConfig.split(";");
        if (ruleSpecs.length == 0) {
            throw new InvalidFilterSpecification("No rules specified");
        }
        boolean haltFilterEncountered = false;
        for (String ruleSpec : ruleSpecs) {
            ruleSpec = ruleSpec.trim();
            ArrayList filterChain = new ArrayList();
            String[] filterSpecs = ruleSpec.split("->");
            boolean allFilterEncountered = false;
            for (String filterSpec : filterSpecs) {
                String[] nonEmptyArgs;
                String[] nameAndArgs = (filterSpec = filterSpec.trim()).split("\\(", 0);
                if (nameAndArgs.length != 2) {
                    throw new InvalidFilterSpecification(String.format("Syntax error filter specification: '%s'", filterSpec));
                }
                String namePart = nameAndArgs[0].trim();
                String argsPart = nameAndArgs[1].trim();
                if (!argsPart.endsWith(")")) {
                    throw new InvalidFilterSpecification(String.format("No closing parenthesis: '%s'", filterSpec));
                }
                argsPart = argsPart.substring(0, argsPart.length() - 1);
                String filterName = namePart.trim();
                if (!filterName.matches("\\w+")) {
                    throw new InvalidFilterSpecification(String.format("Syntax error filter name: '%s'", filterName));
                }
                for (String arg : nonEmptyArgs = Arrays.stream(argsPart.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList()).toArray(new String[0])) {
                    if (arg.matches("[\\w-]+")) continue;
                    throw new InvalidFilterSpecification(String.format("Syntax error argument: '%s'", arg));
                }
                if (haltFilterEncountered) {
                    if (filterChain.size() > 0) {
                        throw new InvalidFilterSpecification(String.format("Filter 'halt' may not be followed by other filters: '%s'", ruleSpec));
                    }
                    throw new InvalidFilterSpecification(String.format("Rule 'halt' may not followed by other rules: '%s'", filterConfig));
                }
                Filter<ServerInfo> filter = FilterConfigParser.filterFor(filterName, nonEmptyArgs);
                if (filter == HaltFilter.INSTANCE) {
                    if (filterChain.size() != 0) {
                        throw new InvalidFilterSpecification(String.format("Filter 'halt' must be the only filter in a rule: '%s'", ruleSpec));
                    }
                    haltFilterEncountered = true;
                    continue;
                }
                if (filter == IdentityFilter.INSTANCE) {
                    if (allFilterEncountered || filterChain.size() != 0) {
                        throw new InvalidFilterSpecification(String.format("Filter 'all' is implicit but allowed only first in a rule: '%s'", ruleSpec));
                    }
                    allFilterEncountered = true;
                    continue;
                }
                filterChain.add(filter);
            }
            if (filterChain.size() <= 0) continue;
            rules.add(new FilterChain(filterChain));
        }
        if (!haltFilterEncountered) {
            rules.add(new FilterChain(Collections.singletonList(IdentityFilter.as())));
        }
        return new FirstValidRule<ServerInfo>(rules);
    }
}

